% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_wqs_formula.R
\name{estimate.wqs.formula}
\alias{estimate.wqs.formula}
\title{Formula for WQS Regression}
\usage{
estimate.wqs.formula(formula, data, chem_mix, ..., verbose = FALSE)
}
\arguments{
\item{formula}{An object of class "formula" that consists of an outcome, chemical mixture, and if any, covariates. See \code{\link[stats]{formula}}.}

\item{data}{The data in a data-frame format}

\item{chem_mix}{Indices or column names of variables to be combined into an index.}

\item{...}{Additional WQS parameters passed to \code{estimate.wqs}. Note: data arguments (y, X, and Z) have no effect.}

\item{verbose}{Logical; if TRUE, prints more information. Useful to check for any errors in the code. Default: FALSE.}
}
\description{
A wrapper function for \code{\link{estimate.wqs}} so that a formula can be used instead.
}
\examples{

#Example 1
set.seed(232)
test.data <- data.frame(x1 = rlnorm(100, 3, 1), x2 = rlnorm(100, 5, 1),
                        z1 = rlnorm(100, 10, 3), z2 = rbinom(100, 1, 0.7),
                        y = rnorm(100, 100, 15)
)
 estimate.wqs.formula(y ~., data = test.data, chem_mix = c("x1", "x2"))

\dontrun{
#Example 2: No covariates
 estimate.wqs.formula(y~ x1 + x2, data = test.data, chem_mix = 1:2)

#Example 3: NA in Z
test.data$z1[10] <- NA
estimate.wqs.formula( y ~., data = test.data, chem_mix = c("x1", "x2"))

#Example 4: NA in Z and y
 test.data$y[1] <- NA
 estimate.wqs.formula( y ~., data = test.data, chem_mix = c("x1", "x2"))


#Example 5: NA in Z, X, and y
test.data$x1[2] <- NA
estimate.wqs.formula( y ~., data = test.data, chem_mix = c("x1", "x2"),
                           place.bdls.in.Q1 = TRUE
)
} #due to time constraints
}
\seealso{
Other wqs: \code{\link{analyze.individually}},
  \code{\link{coef.wqs}}, \code{\link{do.many.wqs}},
  \code{\link{estimate.wqs}},
  \code{\link{make.quantile.matrix}},
  \code{\link{plot.wqs}}, \code{\link{print.wqs}}
}
\concept{wqs}
\keyword{imputation}
\keyword{wqs}
