% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_beta.R
\name{trans_beta}
\alias{trans_beta}
\title{Create trans_beta object for the analysis of distance matrix of beta-diversity.}
\description{
This class is a wrapper for a series of beta-diversity related analysis, 
including several ordination calculations and plotting based on An et al. (2019) <doi:10.1016/j.geoderma.2018.09.035>, group distance comparision, 
clustering, perMANOVA based on Anderson al. (2008) <doi:10.1111/j.1442-9993.2001.01070.pp.x> and PERMDISP.
}
\examples{

## ------------------------------------------------
## Method `trans_beta$new`
## ------------------------------------------------

data(dataset)
t1 <- trans_beta$new(dataset = dataset, measure = "bray", group = "Group")

## ------------------------------------------------
## Method `trans_beta$cal_ordination`
## ------------------------------------------------

t1$cal_ordination(ordination = "PCoA")		

## ------------------------------------------------
## Method `trans_beta$plot_ordination`
## ------------------------------------------------

t1$plot_ordination(plot_color = "Group", plot_shape = "Group", plot_group_ellipse = TRUE)

## ------------------------------------------------
## Method `trans_beta$cal_manova`
## ------------------------------------------------

t1$cal_manova(cal_manova_all = TRUE)

## ------------------------------------------------
## Method `trans_beta$cal_betadisper`
## ------------------------------------------------

t1$cal_betadisper()

## ------------------------------------------------
## Method `trans_beta$cal_group_distance`
## ------------------------------------------------

\donttest{
t1$cal_group_distance(within_group = TRUE)
}

## ------------------------------------------------
## Method `trans_beta$plot_group_distance`
## ------------------------------------------------

\donttest{
t1$plot_group_distance(distance_pair_stat = TRUE)
}

## ------------------------------------------------
## Method `trans_beta$plot_clustering`
## ------------------------------------------------

t1$plot_clustering(group = "Group", replace_name = c("Saline", "Type"))
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{trans_beta$new()}}
\item \href{#method-cal_ordination}{\code{trans_beta$cal_ordination()}}
\item \href{#method-plot_ordination}{\code{trans_beta$plot_ordination()}}
\item \href{#method-cal_manova}{\code{trans_beta$cal_manova()}}
\item \href{#method-cal_betadisper}{\code{trans_beta$cal_betadisper()}}
\item \href{#method-cal_group_distance}{\code{trans_beta$cal_group_distance()}}
\item \href{#method-plot_group_distance}{\code{trans_beta$plot_group_distance()}}
\item \href{#method-plot_clustering}{\code{trans_beta$plot_clustering()}}
\item \href{#method-print}{\code{trans_beta$print()}}
\item \href{#method-clone}{\code{trans_beta$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_beta$new(dataset = NULL, measure = NULL, group = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{the object of \code{\link{microtable}} Class.}

\item{\code{measure}}{default NULL; bray, jaccard, wei_unifrac or unwei_unifrac, or other name of matrix you add; 
beta diversity index used for ordination, manova or group distance.}

\item{\code{group}}{default NULL; sample group used for manova, betadisper or group distance.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
parameters stored in the object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(dataset)
t1 <- trans_beta$new(dataset = dataset, measure = "bray", group = "Group")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_ordination"></a>}}
\if{latex}{\out{\hypertarget{method-cal_ordination}{}}}
\subsection{Method \code{cal_ordination()}}{
Ordination based on An et al. (2019) <doi:10.1016/j.geoderma.2018.09.035>.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_beta$cal_ordination(
  ordination = "PCoA",
  ncomp = 3,
  trans_otu = FALSE,
  scale_species = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ordination}}{default "PCoA"; "PCA", "PCoA" or "NMDS".}

\item{\code{ncomp}}{default 3; the returned dimensions.}

\item{\code{trans_otu}}{default FALSE; whether species abundance will be square transformed, used for PCA.}

\item{\code{scale_species}}{default FALSE; whether species loading in PCA will be scaled.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_ordination stored in the object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t1$cal_ordination(ordination = "PCoA")		
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_ordination"></a>}}
\if{latex}{\out{\hypertarget{method-plot_ordination}{}}}
\subsection{Method \code{plot_ordination()}}{
Plotting the ordination result based on An et al. (2019) <doi:10.1016/j.geoderma.2018.09.035>.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_beta$plot_ordination(
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  shape_values = c(16, 17, 7, 8, 15, 18, 11, 10, 12, 13, 9, 3, 4, 0, 1, 2, 14),
  plot_color = NULL,
  plot_shape = NULL,
  plot_group_order = NULL,
  plot_point_size = 3,
  plot_point_alpha = 0.9,
  plot_sample_label = NULL,
  plot_group_centroid = FALSE,
  plot_group = NULL,
  segment_alpha = 0.6,
  centroid_linetype = 3,
  plot_group_ellipse = FALSE,
  ellipse_level = 0.9,
  ellipse_alpha = 0.1,
  ellipse_type = "t"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color_values}}{default RColorBrewer::brewer.pal(8, "Dark2"); colors for presentation.}

\item{\code{shape_values}}{default c(16, 17, 7, 8, 15, 18, 11, 10, 12, 13, 9, 3, 4, 0, 1, 2, 14); a vector used in the shape type, see ggplot2 tutorial.}

\item{\code{plot_color}}{default NULL; the sample group name used for color in plot.}

\item{\code{plot_shape}}{default NULL; the sample group name used for shape in plot.}

\item{\code{plot_group_order}}{default NULL; a vector used to order the groups in the legend of plot.}

\item{\code{plot_point_size}}{default 3; point size in plot.}

\item{\code{plot_point_alpha}}{default .9; point transparency in plot.}

\item{\code{plot_sample_label}}{default NULL; the column name in sample table, if provided, show the point name in plot.}

\item{\code{plot_group_centroid}}{default FALSE; whether show the centroid in each group of plot.}

\item{\code{plot_group}}{default NULL; the column name in sample table, generally used with plot_group_centroid and plot_group_ellipse.}

\item{\code{segment_alpha}}{default .6; segment transparency in plot.}

\item{\code{centroid_linetype}}{default 3; the line type related with centroid in plot.}

\item{\code{plot_group_ellipse}}{default FALSE; whether show the confidence ellipse in each group of plot.}

\item{\code{ellipse_level}}{default .9; confidence level of ellipse.}

\item{\code{ellipse_alpha}}{default .1; color transparency in the ellipse.}

\item{\code{ellipse_type}}{default t; see type in \code{\link{stat_ellipse}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t1$plot_ordination(plot_color = "Group", plot_shape = "Group", plot_group_ellipse = TRUE)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_manova"></a>}}
\if{latex}{\out{\hypertarget{method-cal_manova}{}}}
\subsection{Method \code{cal_manova()}}{
Calculate perMANOVA based on Anderson al. (2008) <doi:10.1111/j.1442-9993.2001.01070.pp.x> and R vegan adonis function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_beta$cal_manova(
  cal_manova_all = FALSE,
  cal_manova_paired = FALSE,
  cal_manova_set = NULL,
  permutations = 999
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cal_manova_all}}{default FALSE; whether manova is used for all data.}

\item{\code{cal_manova_paired}}{default FALSE; whether manova is used for all the paired groups.}

\item{\code{cal_manova_set}}{default NULL; specified group set for manova, see \code{\link{adonis}}.}

\item{\code{permutations}}{default 999; see permutations in \code{\link{adonis}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_manova stored in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t1$cal_manova(cal_manova_all = TRUE)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_betadisper"></a>}}
\if{latex}{\out{\hypertarget{method-cal_betadisper}{}}}
\subsection{Method \code{cal_betadisper()}}{
A wrapper for betadisper function in vegan package for multivariate homogeneity test of groups dispersions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_beta$cal_betadisper(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{parameters passed to \code{\link{betadisper}} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_betadisper stored in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t1$cal_betadisper()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_group_distance"></a>}}
\if{latex}{\out{\hypertarget{method-cal_group_distance}{}}}
\subsection{Method \code{cal_group_distance()}}{
Transform sample distances within groups or between groups.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_beta$cal_group_distance(within_group = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{within_group}}{default TRUE; whether transform sample distance within groups, if FALSE, transform sample distance between any two groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_group_distance stored in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_group_distance(within_group = TRUE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_group_distance"></a>}}
\if{latex}{\out{\hypertarget{method-plot_group_distance}{}}}
\subsection{Method \code{plot_group_distance()}}{
Plotting the distance between samples within or between groups.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_beta$plot_group_distance(
  plot_group_order = NULL,
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  distance_pair_stat = FALSE,
  pair_compare_filter = "",
  pair_compare_method = "wilcox.test",
  plot_distance_xtype = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot_group_order}}{default NULL; a vector used to order the groups in the plot.}

\item{\code{color_values}}{colors for presentation.}

\item{\code{distance_pair_stat}}{default FALSE; whether do the paired comparisions.}

\item{\code{pair_compare_filter}}{default ""; if provided, remove the matched groups.}

\item{\code{pair_compare_method}}{default wilcox.test; wilcox.test, kruskal.test, t.test or anova.}

\item{\code{plot_distance_xtype}}{default NULL; number used to make x axis text generate angle.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_group_distance(distance_pair_stat = TRUE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_clustering"></a>}}
\if{latex}{\out{\hypertarget{method-plot_clustering}{}}}
\subsection{Method \code{plot_clustering()}}{
Plotting clustering result. Require ggdendro package.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_beta$plot_clustering(
  use_colors = RColorBrewer::brewer.pal(8, "Dark2"),
  measure = NULL,
  group = NULL,
  replace_name = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_colors}}{colors for presentation.}

\item{\code{measure}}{default NULL; beta diversity index; If NULL, using the measure when creating object}

\item{\code{group}}{default NULL; if provided, use this group to assign color.}

\item{\code{replace_name}}{default NULL; if provided, use this as label.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t1$plot_clustering(group = "Group", replace_name = c("Saline", "Type"))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print the trans_beta object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_beta$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_beta$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
