% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plumber-use_microservice.R
\name{use_microservice}
\alias{use_microservice}
\title{Use a plumber Microservice in an R Project}
\usage{
use_microservice(path = ".", overwrite = FALSE)
}
\arguments{
\item{path}{(\code{character}) Where is the project root folder?}

\item{overwrite}{(\code{logical}) Should existing destination files be overwritten?}
}
\value{
No return value, called for side effects.
}
\description{
Lay the infrastructure for a microservice. That includes unit test,
dependency packages, configuration file, entrypoints and utility endpoint.
}
\details{
\subsection{How It Works}{

Given a \code{path} to a folder

When \code{use_microservice(path = ".")} is called

Then the function creates the following files:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tests/testthat/test-endpoint-plumber-utility.R
inst/configurations/plumber.yml
inst/endpoints/plumber-utility.R
inst/entrypoints/plumber-background.R
inst/entrypoints/plumber-foreground.R
}\if{html}{\out{</div>}}

And updates the following files:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tests/testthat/helpers-xyz.R
}\if{html}{\out{</div>}}

And adds the following packages to the DESCRIPTION file:\tabular{lll}{
   type \tab package \tab version \cr
   Suggests \tab config \tab * \cr
   Suggests \tab httptest \tab * \cr
   Suggests \tab httr \tab * \cr
   Imports \tab jsonlite \tab * \cr
   Suggests \tab pkgload \tab * \cr
   Suggests \tab plumber \tab >= 1.0.0 \cr
   Imports \tab purrr \tab * \cr
   Suggests \tab testthat \tab * \cr
   Suggests \tab usethis \tab * \cr
   Suggests \tab promises \tab * \cr
   Suggests \tab future \tab * \cr
}

}

\subsection{When to Use \code{plumber}}{
\itemize{
\item A Single user/machine applications.
\item Scheduled tasks. For example, you could use \href{https://airflow.apache.org/docs/apache-airflow-providers-http/stable/operators.html}{AirFlow with HTTP Operators}
to automate processes.
}
\subsection{\code{plumber} Advantages}{
\itemize{
\item Comes with familiar way to document the microservice endpoint.
\item Maturing package that comes with documentation, examples and support.
}
}

\subsection{\code{plumber} Disadvantages}{
\itemize{
\item Runs on a single thread. That means that parallel algorithms such as random
forest, can only be run on one core.
\item Serves only one caller at a time.
\item Can't make inward calls for other services, That means plumber can't be
\href{https://en.wikipedia.org/wiki/Reentrancy_(computing)}{re-entrant}. For
example, if a microservice has three endpoints,\code{read_table}, \code{write_table},
and \code{orchestrator}, where the \code{orchestrator} reads a data table, transforms
it, and writes it back, then the \code{orchestrator} can't make inwards calls via
HTTP to \code{read_table} and \code{write_table}.
}<div class="alert alert-warning">
**Note:** While `plumber` is single-threaded by nature, it is possible to perform
 parallel execution using the `promises` package. See links under References.
</div>

}

}

\subsection{Workflow}{
\enumerate{
\item Deploy the Microservice infrastructure
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{microservices::use_microservice(path = ".")
remotes::install_deps(dependencies = TRUE)
devtools::document()
}\if{html}{\out{</div>}}
\enumerate{
\item Spin-up the microservice by running
\code{source("./inst/entrypoints/plumber-background.R")}
\item Run the microservice unit-test by pressing Ctrl+Shift+T on Windows
}

Congratulations! You have added a microservice to your application and tested
that it works.
}

\subsection{References}{
\itemize{
\item \href{https://www.rstudio.com/blog/plumber-v1-1-0/#parallel-exec}{Parallel execution in plumber}
\item \href{https://rstudio.github.io/promises/articles/overview.html}{\code{promises} package}
}
}
}
\examples{
path <- tempfile()
use_microservice(path)

list.files(path, recursive = TRUE)

cat(read.dcf(file.path(path, "DESCRIPTION"), "Imports"))
cat(read.dcf(file.path(path, "DESCRIPTION"), "Suggests"))
}
\seealso{
Other plumber microservice: 
\code{\link{add_service}()}
}
\concept{plumber microservice}
