% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RecombinatorMaybe.R
\name{dict_recombinators_maybe}
\alias{dict_recombinators_maybe}
\alias{RecombinatorMaybe}
\title{Recombinator Choosing Action Probabilistically}
\description{
\code{\link{Recombinator}} that chooses which operation to perform probabilistically. The \code{\link{Recombinator}} wraps two other \code{\link{Recombinator}}s given during construction,
and for each group of \verb{$n_indivs_in} individuals, the operation to perform is sampled: with probability \code{p} (configuration parameter), the \code{\link{Recombinator}} given to
the \code{recombinator} construction argument is applied, and with probability \code{p - 1} the one given to \code{recombinator_not} is applied.

The values of \verb{$n_indivs_in} and \verb{$n_indivs_out} is set to the corresponding values of the wrapped \code{\link{Recombinator}}s. Both \code{recombinator} and \code{recombinator_not}
must currently have the same respective \verb{$n_indivs_in} and \verb{$n_indivs_out} values.
}
\section{Configuration Parameters}{

This operator has the configuration parameters of the \code{\link{Recombinator}}s that it wraps: The configuration parameters of the operator given to the \code{recombinator} construction argument
are prefixed with \code{"maybe."}, the configuration parameters of the operator given to the \code{recombinator_not} construction argument are prefixed with \code{"maybe_not."}.

Additional configuration parameters:
\itemize{
\item \code{p} :: \code{numeric(1)} \cr
Probability per group of \code{n_indivs_in} individuals with which to apply the operator given to the \code{recombinator} construction argument. Must be set by the user.
}
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Param]{Param}} classes are the set intersection of supported classes of \code{recombinator} and \code{recombinator_not}.
}

\section{Dictionary}{

This \code{\link{Recombinator}} can be created with the short access form \code{\link[=rec]{rec()}}
(\code{\link[=recs]{recs()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_recombinators}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
rec("maybe", <recombinator> [, <recombinator_not>])
recs("maybe", <recombinator> [, <recombinator_not>])  # takes vector IDs, returns list of Recombinators

# long form:
dict_recombinators$get("maybe", <recombinator> [, <recombinator_not>])
}\if{html}{\out{</div>}}
}

\examples{
set.seed(1)
rm = rec("maybe", rec("xounif", p = 1), p = 0.5)
p = ps(x = p_int(1, 8), y = p_dbl(1, 8), z = p_lgl())
data = data.frame(x = 1:8, y = 1:8, z = rep(TRUE, 4))

rm$prime(p)
rm$operate(data)

rm$param_set$values$p = 0.3
rm$operate(data)

rm2 = rec("maybe",
  recombinator = rec("xounif", p = 1),
  recombinator_not = rec("xounif", p = 0.5),
  p = 0.5
)

rm2$prime(p)
rm2$operate(data)
}
\seealso{
Other recombinators: 
\code{\link{OperatorCombination}},
\code{\link{RecombinatorPair}},
\code{\link{Recombinator}},
\code{\link{dict_recombinators_cmpmaybe}},
\code{\link{dict_recombinators_convex}},
\code{\link{dict_recombinators_cvxpair}},
\code{\link{dict_recombinators_null}},
\code{\link{dict_recombinators_proxy}},
\code{\link{dict_recombinators_sbx}},
\code{\link{dict_recombinators_sequential}},
\code{\link{dict_recombinators_swap}},
\code{\link{dict_recombinators_xonary}},
\code{\link{dict_recombinators_xounif}}

Other recombinator wrappers: 
\code{\link{OperatorCombination}},
\code{\link{dict_recombinators_cmpmaybe}},
\code{\link{dict_recombinators_proxy}},
\code{\link{dict_recombinators_sequential}}
}
\concept{recombinator wrappers}
\concept{recombinators}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Recombinator]{miesmuschel::Recombinator}} -> \code{RecombinatorMaybe}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{recombinator}}{(\code{\link{Recombinator}})\cr
\code{\link{Recombinator}} being wrapped. This operator gets run with probability \code{p} (configuration parameter).}

\item{\code{recombinator_not}}{(\code{\link{Recombinator}})\cr
Alternative \code{\link{Recombinator}} being wrapped. This operator gets run with probability \code{1 - p} (configuration parameter).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RecombinatorMaybe-new}{\code{RecombinatorMaybe$new()}}
\item \href{#method-RecombinatorMaybe-prime}{\code{RecombinatorMaybe$prime()}}
\item \href{#method-RecombinatorMaybe-clone}{\code{RecombinatorMaybe$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecombinatorMaybe-new"></a>}}
\if{latex}{\out{\hypertarget{method-RecombinatorMaybe-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{RecombinatorMaybe} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecombinatorMaybe$new(recombinator, recombinator_not = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{recombinator}}{(\code{\link{Recombinator}})\cr
\code{\link{Recombinator}} to wrap. This operator gets run with probability \code{p} (Configuration parameter).\cr
The constructed object gets a \emph{clone} of this argument.
The \verb{$recombinator} field will reflect this value.}

\item{\code{recombinator_not}}{(\code{\link{Recombinator}})\cr
Another \code{\link{Recombinator}} to wrap. This operator runs when \code{recombinator} is not chosen. By
default, this is \code{\link{RecombinatorNull}}, i.e. no operation, with both \code{n_indivs_in} and \code{n_indivs_out} set
to match \code{recombinator}. This does not work when \code{recombinator} has \code{n_indivs_in < n_indivs_out}, in which
case this argument must be set explicitly.\cr
With this default, the \code{RecombinatorMaybe} object applies the \code{recombinator} operation with probability \code{p}, and
no operation at all otherwise.\cr
The constructed object gets a \emph{clone} of this argument.
The \verb{$recombinator_not} field will reflect this value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecombinatorMaybe-prime"></a>}}
\if{latex}{\out{\hypertarget{method-RecombinatorMaybe-prime}{}}}
\subsection{Method \code{prime()}}{
See \code{\link{MiesOperator}} method. Primes both this operator, as well as the wrapped operators
given to \code{recombinator} and \code{recombinator_not} during construction.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecombinatorMaybe$prime(param_set)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}})\cr
Passed to \code{\link{MiesOperator}}\verb{$prime()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{invisible} \code{self}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecombinatorMaybe-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RecombinatorMaybe-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecombinatorMaybe$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
