% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScalorOne.R
\name{dict_scalors_one}
\alias{dict_scalors_one}
\alias{ScalorOne}
\title{Single Dimension Scalor}
\description{
\code{\link{Scalor}} that returns a the fitness value of a single objective dimension as scale.
}
\section{Configuration Parameters}{

\itemize{
\item \code{objective} :: \code{integer(1)}\cr
objective to return as scale, ranges from 1 (the default, first objective) to the number of objectives
of the function being optimized.
}
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Param]{Param}} classes are: \code{\link[paradox:ParamLgl]{ParamLgl}}, \code{\link[paradox:ParamInt]{ParamInt}}, \code{\link[paradox:ParamDbl]{ParamDbl}}, \code{\link[paradox:ParamFct]{ParamFct}}
}

\section{Dictionary}{

This \code{\link{Scalor}} can be created with the short access form \code{\link[=scl]{scl()}}
(\code{\link[=scls]{scls()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_scalors}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
scl("one")
scls("one")  # takes vector IDs, returns list of Scalors

# long form:
dict_scalors$get("one")
}\if{html}{\out{</div>}}
}

\examples{
so = scl("one")
p = ps(x = p_dbl(-5, 5))
# dummy data; note that ScalorOne does not depend on data content
data = data.frame(x = rep(0, 5))
fitnesses = matrix(c(1, 5, 2, 3, 0, 3, 1, 0, 10, 8), ncol = 2)

so$prime(p)

so$operate(data, fitnesses)

so$param_set$values$objective = 2

so$operate(data, fitnesses)
}
\seealso{
Other scalors: 
\code{\link{Scalor}},
\code{\link{dict_scalors_aggregate}},
\code{\link{dict_scalors_domcount}},
\code{\link{dict_scalors_fixedprojection}},
\code{\link{dict_scalors_hypervolume}},
\code{\link{dict_scalors_nondom}},
\code{\link{dict_scalors_proxy}},
\code{\link{dict_scalors_single}}
}
\concept{scalors}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Scalor]{miesmuschel::Scalor}} -> \code{ScalorOne}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ScalorOne-new}{\code{ScalorOne$new()}}
\item \href{#method-ScalorOne-clone}{\code{ScalorOne$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="prime"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-prime'><code>miesmuschel::MiesOperator$prime()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ScalorOne-new"></a>}}
\if{latex}{\out{\hypertarget{method-ScalorOne-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{ScalorOne} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScalorOne$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ScalorOne-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ScalorOne-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScalorOne$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
