% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SelectorProxy.R
\name{dict_selectors_proxy}
\alias{dict_selectors_proxy}
\alias{SelectorProxy}
\title{Proxy-Selector that Selects According to its Configuration Parameter}
\description{
\code{\link{Selector}} that performs the operation in its \code{operation} configuration parameter. This is useful, e.g., to make
\code{\link{OptimizerMies}}'s selection operations fully parametrizable.
}
\section{Configuration Parameters}{

\itemize{
\item \code{operation} :: \code{\link{Selector}}\cr
Operation to perform. Initialized to \code{\link{SelectorBest}}.
This is primed when \verb{$prime()} of \code{SelectorProxy} is called, and also when \verb{$operate()} is called, to make changing
the operation as part of self-adaption possible. However, if the same operation gets used inside multiple \code{SelectorProxy}
objects, then it is recommended to \verb{$clone(deep = TRUE)} the object before assigning them to \code{operation} to avoid
frequent re-priming.
}
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Domain]{Domain}} classes are: \code{\link[paradox:Domain]{p_lgl}} ('ParamLgl'), \code{\link[paradox:Domain]{p_int}} ('ParamInt'), \code{\link[paradox:Domain]{p_dbl}} ('ParamDbl'), \code{\link[paradox:Domain]{p_fct}} ('ParamFct')
}

\section{Dictionary}{

This \code{\link{Selector}} can be created with the short access form \code{\link[=sel]{sel()}}
(\code{\link[=sels]{sels()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_selectors}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
sel("proxy")
sels("proxy")  # takes vector IDs, returns list of Selectors

# long form:
dict_selectors$get("proxy")
}\if{html}{\out{</div>}}
}

\examples{
set.seed(1)
sp = sel("proxy")
p = ps(x = p_dbl(-5, 5))
# dummy data; note that SelectorBest does not depend on data content
data = data.frame(x = rep(0, 5))
fitnesses = c(1, 5, 2, 3, 0)

sp$param_set$values$operation = sel("random")
sp$prime(p)
sp$operate(data, fitnesses, 2)

sp$param_set$values$operation = sel("best")
sp$operate(data, fitnesses, 2)
}
\seealso{
Other selectors: 
\code{\link{Selector}},
\code{\link{SelectorScalar}},
\code{\link{dict_selectors_best}},
\code{\link{dict_selectors_maybe}},
\code{\link{dict_selectors_null}},
\code{\link{dict_selectors_random}},
\code{\link{dict_selectors_sequential}},
\code{\link{dict_selectors_tournament}}

Other selector wrappers: 
\code{\link{dict_selectors_maybe}},
\code{\link{dict_selectors_sequential}}
}
\concept{selector wrappers}
\concept{selectors}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Selector]{miesmuschel::Selector}} -> \code{SelectorProxy}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SelectorProxy-new}{\code{SelectorProxy$new()}}
\item \href{#method-SelectorProxy-prime}{\code{SelectorProxy$prime()}}
\item \href{#method-SelectorProxy-clone}{\code{SelectorProxy$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SelectorProxy-new"></a>}}
\if{latex}{\out{\hypertarget{method-SelectorProxy-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{SelectorProxy} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SelectorProxy$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SelectorProxy-prime"></a>}}
\if{latex}{\out{\hypertarget{method-SelectorProxy-prime}{}}}
\subsection{Method \code{prime()}}{
See \code{\link{MiesOperator}} method. Primes both this operator, as well as the operator given to the \code{operation} configuration parameter.
Note that this modifies the \verb{$param_set$values$operation} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SelectorProxy$prime(param_set)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}})\cr
Passed to \code{\link{MiesOperator}}\verb{$prime()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{invisible} \code{self}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SelectorProxy-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SelectorProxy-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SelectorProxy$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
