% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_from_lifetime.R
\name{net_from_lifetime}
\alias{net_from_lifetime}
\title{Estimate net migration from lifetime migration data}
\usage{
net_from_lifetime(
  .data,
  in_migrant = "in_migrants",
  out_migrant = "out_migrants",
  year = "year",
  in_survival,
  out_survival
)
}
\arguments{
\item{.data}{A data frame with two rows with the total number of lifetime in- and out-migrants in separate columns. The first row contains totals at the first time point and second row at the second time point.}

\item{in_migrant}{Character string name of column containing in-migrant counts. Default `code{"in_migrants"}`.}

\item{out_migrant}{Character string name of column containing out-migrant counts. Default `code{"out_migrants"}`.}

\item{year}{Character string name of column containing time points. Default `code{"year"}`.}

\item{in_survival}{Survival probability for foreign migrants in region}

\item{out_survival}{Survival probability for native migrants outside of region}
}
\value{
Data frame with estimates of net migration
}
\description{
Estimate net migration from lifetime migration data
}
