% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stripe_matrix.R
\name{stripe_matrix}
\alias{stripe_matrix}
\title{Create a stripped matrix with non-uniform block sizes.}
\usage{
stripe_matrix(x = NULL, s = NULL, byrow = FALSE, dimnames = NULL)
}
\arguments{
\item{x}{Vector of numbers to identify each stripe.}

\item{s}{Vector of values for the size of the stripes, order depending on \code{byrow}}

\item{byrow}{Logical value. If \code{FALSE} (the default) the stripes are filled by columns, otherwise the stripes in the matrix are filled by rows.}

\item{dimnames}{Character string of name attribute for the basis of the stripped matrix. If \code{NULL} a vector of the same length of \code{s} provides the basis of row and column names.}
}
\value{
Returns a \code{matrix} with stripe sizes determined by the \code{s} argument. Each stripe is filled with the same value taken from \code{x}.
}
\description{
Create a stripped matrix with non-uniform block sizes.
}
\examples{
stripe_matrix(x = 1:44, s = c(2,3,4,2), dimnames = LETTERS[1:4], byrow = TRUE)
}
\seealso{
\code{\link{block_matrix}}, \code{\link{block_sum}}, \code{\link{ipf2_stripe}}
}
\author{
Guy J. Abel
}
