% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_holes.R
\name{holes}
\alias{holes}
\alias{node_bridges}
\alias{node_redundancy}
\alias{node_effsize}
\alias{node_efficiency}
\alias{node_constraint}
\alias{node_hierarchy}
\title{Measures of structural holes}
\usage{
node_bridges(object)

node_redundancy(object)

node_effsize(object)

node_efficiency(object)

node_constraint(object)

node_hierarchy(object)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\description{
These function provide different measures of the degree to which nodes
fill structural holes, as outlined in Burt (1992).
Burt's theory holds that while those nodes embedded in dense clusters
of close connections are likely exposed to the same or similar ideas and information,
those who fill structural holes between two otherwise disconnected groups
can gain some comparative advantage from that position.
}
\details{
A number of different ways of measuring these structural holes are available.
Note that we use Borgatti's reformulation for unweighted networks in
\code{node_redundancy()} and \code{node_effsize()}.
Redundancy is thus \eqn{\frac{2t}{n}},
where \eqn{t} is the sum of ties and \eqn{n} the sum of nodes in each node's neighbourhood,
and effective size is calculated as \eqn{n - \frac{2t}{n}}.
}
\section{Functions}{
\itemize{
\item \code{node_bridges}: Returns the sum of bridges to which each node
is adjacent.

\item \code{node_redundancy}: Returns a measure of the redundancy of each nodes'
contacts.

\item \code{node_effsize}: Returns nodes' effective size

\item \code{node_efficiency}: Returns nodes' efficiency

\item \code{node_constraint}: Returns nodes' constraint scores for one-mode networks
according to Burt (1992) and for two-mode networks according to Hollway et al (2020).

\item \code{node_hierarchy}: Returns nodes' exposure to hierarchy,
where only one or two contacts are the source of closure
}}

\examples{
node_bridges(ison_adolescents)
node_bridges(ison_southern_women)
node_redundancy(ison_adolescents)
node_redundancy(ison_southern_women)
node_effsize(ison_adolescents)
node_effsize(ison_southern_women)
node_efficiency(ison_adolescents)
node_efficiency(ison_southern_women)
node_constraint(ison_southern_women)
node_hierarchy(ison_adolescents)
node_hierarchy(ison_southern_women)
}
\references{
Burt, Ronald S. 1992.
\emph{Structural Holes: The Social Structure of Competition}.
Cambridge, MA: Harvard University Press.

Borgatti, Steven. 1997.
“\href{http://www.analytictech.com/connections/v20(1)/holes.htm}{Structural Holes: Unpacking Burt’s Redundancy Measures}”
\emph{Connections} 20(1):35-38.

Hollway, James, Jean-Frédéric Morin, and Joost Pauwelyn. 2020.
"Structural conditions for novelty: the introduction of new environmental clauses to the trade regime complex."
\emph{International Environmental Agreements: Politics, Law and Economics} 20 (1): 61–83.
\doi{10.1007/s10784-019-09464-5}.
}
\seealso{
Other measures: 
\code{\link{centralisation}},
\code{\link{centrality}},
\code{\link{closure}},
\code{\link{cohesion}()},
\code{\link{diversity}},
\code{\link{features}}
}
\concept{measures}
