% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz_layout.R
\name{layouts}
\alias{layouts}
\alias{layout_tbl_graph_frgrid}
\alias{layout_tbl_graph_kkgrid}
\alias{layout_tbl_graph_gogrid}
\alias{layout_tbl_graph_stressgrid}
\title{Layouts for snapping layouts to a grid}
\usage{
layout_tbl_graph_frgrid(object, circular = FALSE, times = 1000)

layout_tbl_graph_kkgrid(object, circular = FALSE, times = 1000)

layout_tbl_graph_gogrid(object, circular = FALSE, times = 1000)

layout_tbl_graph_stressgrid(object, circular = FALSE, times = 1000)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{circular}{Should the layout be transformed into a radial representation.
Only possible for some layouts. Defaults to FALSE}

\item{times}{Maximum number of iterations, where appropriate}
}
\description{
The function uses approximate pattern matching
to redistribute coarse layouts on square grid points, while
preserving the topological relationships among the nodes (see Inoue et al. 2012).
}
\references{
Inoue, Kentaro, Shinichi Shimozono, Hideaki Yoshida, and Hiroyuki Kurata. 2012.
“Application of Approximate Pattern Matching in Two Dimensional Spaces to Grid Layout for Biochemical Network Maps” edited by J. Bourdon.
\emph{PLoS ONE} 7(6):e37739.
\doi{https://doi.org/10.1371/journal.pone.0037739}.
}
\seealso{
Other mapping: 
\code{\link{autographr}()}
}
\concept{mapping}
