% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_nest.R
\name{export_nest}
\alias{export_nest}
\title{Export Nested Data with Advanced Grouping and Flexible Handling}
\usage{
export_nest(
  nest_dt,
  group_cols = NULL,
  nest_col = NULL,
  export_path = tempdir(),
  file_type = "txt"
)
}
\arguments{
\item{nest_dt}{A \code{data.frame} or \code{data.table} containing nested columns of \code{data.frame}s,
\code{data.table}s, or lists to be exported.}

\item{group_cols}{Optional character vector specifying grouping columns.
If \code{NULL}, uses all non-nested columns as grouping variables.}

\item{nest_col}{Optional character string indicating the nested column to export.
If \code{NULL}, automatically selects the first nested column.}

\item{export_path}{Base directory path for file export. Defaults to a temporary directory
created by \code{tempdir()}.}

\item{file_type}{File export format, either \code{"txt"} (tab-separated) or \code{"csv"}.
Defaults to \code{"txt"}.}
}
\value{
An \code{integer} representing the total number of files exported successfully.
}
\description{
The \code{export_list} function exports nested data from a \code{data.frame} or \code{data.table} with sophisticated grouping
capabilities, supporting multiple nested column types and flexible file export options.
}
\details{
Comprehensive Nested Data Export Features:
\itemize{
\item Automatic detection and handling of different nested column types
\item Flexible grouping strategies with intelligent column selection
\item Hierarchical directory structure generation based on grouping columns
\item Support for mixed nested column types (\code{data.frame}, \code{data.table}, \code{list})
\item Multi-threaded file writing for enhanced performance
\item Informative messaging and warning system
}

Nested Column Detection Hierarchy:
\enumerate{
\item Prioritizes \code{data.frame}/\code{data.table} nested columns
\item Falls back to regular \code{list} columns if no \code{data.frame} columns exist
}

Grouping Column Selection Strategy:
\enumerate{
\item When \code{group_cols} is \code{NULL}, uses all non-nested columns
\item Provides warnings about unused non-nested columns
\item Validates provided group columns
}

File Export Characteristics:
\itemize{
\item Supports \code{"txt"} (tab-separated) and \code{"csv"} formats
\item Uses multi-threading via \code{parallel::detectCores()}
\item Creates nested directory structure based on grouping variables
}
}
\note{
Key Capabilities:
\itemize{
\item Handles complex nested data structures
\item Performs type conversion for nested content
\item Utilizes multi-threaded file export for optimal performance
\item Provides comprehensive column selection feedback
}
}
\examples{
# Example 1: Basic nested data export workflow
# Step 1: Create nested data structure
dt_nest <- w2l_nest(
  data = iris,              # Input iris dataset
  cols2l = 1:2,             # Columns to be nested
  by = "Species"            # Grouping variable
)

# Step 2: Export nested data to files
export_nest(
  nest_dt = dt_nest,        # Input nested data.table
  nest_col = "data",        # Column containing nested data
  group_cols = c("name", "Species")  # Columns to create directory structure
)
# Returns the number of files created
# Creates directory structure: tempdir()/name/Species/data.txt

# Check exported files
list.files(
  path = tempdir(),         # Default export directory
  pattern = "txt",          # File type pattern to search
  recursive = TRUE          # Search in subdirectories
)
# Returns list of created files and their paths

# Clean up exported files
files <- list.files(
  path = tempdir(),         # Default export directory
  pattern = "txt",          # File type pattern to search
  recursive = TRUE,         # Search in subdirectories
  full.names = TRUE         # Return full file paths
)
file.remove(files)          # Remove all exported files
}
