% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregexprind.R
\name{gregexprind}
\alias{gregexprind}
\title{Pattern Matching and Extraction}
\usage{
gregexprind(pattern, text, n, ...)
}
\arguments{
\item{pattern}{Character string containing a regular expression to be searched in \code{text}.}

\item{text}{Character vector where the search is performed.}

\item{n}{Numeric value or character string \code{"last"} to 
extract \code{n}th or last position of \code{pattern} in each value of \code{text}.}

\item{...}{Arguments passed to function \code{gregexpr()}.}
}
\value{
Numeric vector of length \code{length(text)}.
}
\description{
Function to extract a certain index from \code{gregexpr()}.
}
\examples{
#

gregexprind(c("a"),c("ababa","ab","xyz",NA), 1)
gregexprind(c("a"),c("ababa","ab","xyz",NA), 2)
gregexprind(c("a"),c("ababa","ab","xyz",NA), "last")

#
}
\author{
Sven E. Templer
}
\seealso{
See \link{gregexpr} for further information on arguments.\cr
See \link{regex} for the use of regular expressions.
}
\keyword{expression}
\keyword{gregexpr}
\keyword{index}
\keyword{regular}

