% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale0.R
\name{scale0}
\alias{scale0}
\alias{scaler}
\alias{scaler}
\title{Scale Numeric Values to Defined Ranges}
\usage{
scale0(x)

scaler(x, r = c(0, 1), b = range(x, na.rm = TRUE))
}
\arguments{
\item{x}{Numeric vector to transform.}

\item{r}{Numeric vector of length 2 for range to scale values of 
\code{x} to.}

\item{b}{Numeric vector of length 2 to define the border of \code{x}
to use as scaling minimum and maximum.}
}
\description{
Scale numeric values to a range from 0 to 1 with the function
\code{scale0} or to a chosen range with \code{scaler}.
}
\examples{
#

scale0(0:10)
scale0(-1:3)
scale0(2:3)

scaler(0:10)
scaler(0:10, 1:2)
scaler(0:10, 1:2, c(0, 20))

#
}
\author{
Sven E. Templer
}
\keyword{scale}
