% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_rank.R
\name{delete_MAR_rank}
\alias{delete_MAR_rank}
\title{Create MAR values using a ranking mechanism}
\usage{
delete_MAR_rank(ds, p, miss_cols, ctrl_cols, ties.method = "average")
}
\arguments{
\item{ds}{a data frame or matrix in which missing values will be created}

\item{p}{a numeric vector with length one or equal to length \code{miss_cols};
the probability that a value is missing}

\item{miss_cols}{a vector of column names or indices of columns in which
missing values will be created}

\item{ctrl_cols}{a vector of column names or indices of columns, which
controls the creation of missing values in \code{miss_cols}. Must be of the
same length as \code{miss_cols}.}

\item{ties.method}{how ties are handled, passed to \code{\link[base]{rank}}}
}
\value{
An object of the same class as \code{ds} with missing values
}
\description{
Create missing at random (MAR) values using a ranking mechanism in a data frame or
a matrix
}
\details{
This function creates missing at random (MAR) values in the columns
specified by the argument \code{miss_cols}.
The probability for missing values is controlled by \code{p}.
If \code{p} is a single number, then the overall probability for a value to
be missing will be \code{p} in all columns of \code{miss_cols}.
(Internally \code{p} will be replicated to a vector of the same length as
\code{miss_cols}.
So, all \code{p[i]} in the following sections will be equal to the given
single number \code{p}.)
Otherwise, \code{p} must be of the same length as \code{miss_cols}.
In this case, the overall probability for a value to be missing will be
\code{p[i]} in the column \code{miss_cols[i]}.
The position of the missing values in \code{miss_cols[i]} is controlled by
\code{ctrl_cols[i]}.
The following procedure is applied for each pair of \code{ctrl_cols[i]} and
\code{miss_cols[i]} to determine the positions of missing values:

The probability for a missing value in a row of \code{miss_cols[i]} is
proportional to the rank of the value in \code{ctrl_cols[i]} in the same row.
In total \code{round(nrow(ds) * p[i])} missing values are created in
\code{miss_cols[i]}.
The ranks are calculated via \code{\link[base]{rank}}.
The argument \code{ties.method} is directly passed to this function.
Possible choices for \code{ties.method} are documented in
\code{\link[base]{rank}}.
}
\examples{
ds <- data.frame(X = 1:20, Y = 101:120)
delete_MAR_rank(ds, 0.2, "X", "Y")
}
\references{
Santos, M. S., Pereira, R. C., Costa, A. F., Soares, J. P.,
  Santos, J., & Abreu, P. H. (2019). Generating Synthetic Missing Data: A
  Review by Missing Mechanism. \emph{IEEE Access}, 7, 11651-11667
}
\seealso{
\code{\link[base]{rank}}, \code{\link{delete_MNAR_rank}}

Other functions to create MAR: 
\code{\link{delete_MAR_1_to_x}()},
\code{\link{delete_MAR_censoring}()},
\code{\link{delete_MAR_one_group}()}
}
\concept{functions to create MAR}
