% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.cv.missoNet.R
\name{predict.cv.missoNet}
\alias{predict.cv.missoNet}
\title{Make predictions from a cv.missoNet object}
\usage{
\method{predict}{cv.missoNet}(object, newx = NULL, s = "lambda.min", ...)
}
\arguments{
\item{object}{A fitted \code{'cv.missoNet'} object.}

\item{newx}{A predictor matrix of new values at which predictions are to be made. The columns of \code{'newx'} should have the same standardization flags as the original input for training the model. Missing values are not allowed. \code{'newx'} should not include a column of ones for an intercept.}

\item{s}{Character string, the regularization parameter pair \eqn{\lambda} = (\eqn{\lambda_B}, \eqn{\lambda_\Theta}) at which the coefficients are extracted for making predictions. It supports three special strings, named "\code{lambda.min}" (default), "\code{lambda.1se.Beta}" and "\code{lambda.1se.Theta}".}

\item{...}{Not used. Other arguments for predicting.}
}
\value{
The matrix of predicted values: \code{'newy = mu_hat + newx \%*\% Beta_hat'}.
}
\description{
S3 method for making predictions of response values from a fitted \code{'cv.missoNet'} object.
}
\examples{
## Simulate a dataset.
sim.dat <- generateData(n = 300, p = 10, q = 10, rho = 0.1, missing.type = "MCAR")
tr <- 1:240  # training set indices
tst <- 241:300  # test set indices

\donttest{
## Perform a five-fold cross-validation on the training set.
cvfit <- cv.missoNet(X = sim.dat$X[tr, ], Y = sim.dat$Z[tr, ], kfold = 5,
                     fit.1se = TRUE, permute = TRUE, with.seed = 123)


## Make predictions of response values on the test set.
newy1 <- predict(cvfit, newx = sim.dat$X[tst, ], s = "lambda.min")
newy2 <- predict(cvfit, newx = sim.dat$X[tst, ], s = "lambda.1se.Beta")  # 'fit.1se' = TRUE
newy3 <- predict(cvfit, newx = sim.dat$X[tst, ], s = "lambda.1se.Theta")  # 'fit.1se' = TRUE
}
}
\author{
Yixiao Zeng \email{yixiao.zeng@mail.mcgill.ca}, Celia M.T. Greenwood and Archer Yi Yang.
}
