% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha.coef.R
\name{alpha.coef}
\alias{alpha.coef}
\title{Coefficient Alpha and Item Statistics}
\usage{
alpha.coef(x, exclude = NULL, std = FALSE, use = c("listwise", "pairwise"),
           print = c("all", "alpha", "item"), digits = 2,
           conf.level = 0.95, as.na = NULL, check = TRUE, output = TRUE)
}
\arguments{
\item{x}{a matrix, data frame, variance-covariance or correlation matrix.}

\item{exclude}{a character vector indicating items to be excluded from the analysis.}

\item{std}{logical: if \code{TRUE} the standardized coefficient alpha is computed.}

\item{use}{a character string indicating a method for computing a correlation or variance-covariance
matrix in the presence of missing values, i.e., \code{"listwise"} for listwise deletion
and \code{"pairwise"} (default) for pairwise deletion.}

\item{print}{a character vector indicating which results to show, i.e. \code{"all"} (default), for all
results \code{"alpha"} for the coefficienta alpha, and \code{"item"} for item statistics.}

\item{digits}{an integer value indicating the number of decimal places to be used for displaying
coefficient alpha and item-total correlations.}

\item{conf.level}{a numeric value between 0 and 1 indicating the confidence level of the interval.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{output}{logical: if \code{TRUE}, output is shown.}
}
\value{
Returns an object of class \code{alpha.coef}, which is a list with following entries: function call (\code{call}),
matrix or data frame specified in \code{x} (\code{data}), specification of function arguments (\code{args}), and
list with results (\code{result}).
}
\description{
This function computes point estimate and confidence interval for the coefficient alpha (aka Cronbach's alpha)
along with the corrected item-total correlation and coefficient alpha if item deleted.
}
\details{
Confidence intervals are computed using the procedure by Feld, Woodruff and Salih (1987). When computing
confidence intervals using pairwise deletion, the average sample size from all pairwise samples is used.
Note that there are at least 10 other procedures for computing the confidence interval (see Kelley and
Pornprasertmanit, 2016), which are implemented in the \code{ci.reliability()} function in the
\pkg{MBESSS} package by Ken Kelley (2019).
}
\examples{
dat <- data.frame(item1 = c(5, 2, 3, 4, 1, 2, 4, 2),
                  item2 = c(5, 1, 3, 5, 2, 2, 5, 1),
                  item3 = c(4, 2, 4, 5, 1, 3, 5, 1),
                  item4 = c(5, 1, 2, 5, 2, 3, 4, 2))

# Compute unstandardized coefficient alpha and item statistics
alpha.coef(dat)

# Compute standardized coefficient alpha and item statistics
alpha.coef(dat, std = TRUE)

# Compute unstandardized coefficient alpha
alpha.coef(dat, print = "alpha")

# Compute item statistics
alpha.coef(dat, print = "item")

# Compute unstandardized coefficient alpha and item statistics while excluding item3
alpha.coef(dat, exclude = "item3")

# Compute variance-covariance matrix
dat.cov <- cov(dat)
# Compute unstandardized coefficient alpha based on the variance-covariance matrix
alpha.coef(dat.cov)

# Compute variance-covariance matrix
dat.cor <- cor(dat)
# Compute standardized coefficient alpha based on the correlation matrix
alpha.coef(dat.cor)
}
\references{
Cronbach, L.J. (1951). Coefficient alpha and the internal strucuture of tests. \emph{Psychometrika, 16}, 297-334.

Cronbach, L.J. (2004). My current thoughts on coefficient alpha and successor procedures. \emph{Educational
and Psychological Measurement, 64}, 391-418.

Feldt, L. S., Woodruff, D. J., & Salih, F. A. (1987). Statistical inference for coefficient alpha.
\emph{Applied Psychological Measurement}, 11 93-103.

Kelley, K., & Pornprasertmanit, S. (2016). Confidence intervals for population reliability coefficients:
Evaluation of methods, recommendations, and software for composite measures. \emph{Psychological Methods, 21}, 69-92.

Ken Kelley (2019). \emph{MBESS: The MBESS R Package}. R package version 4.6.0.
https://CRAN.R-project.org/package=MBESS
}
\seealso{
\code{\link{reverse.item}}, \code{\link{scores}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
