\name{NMixRelabel}
\alias{NMixRelabel}
\alias{NMixRelabel.default}
\alias{NMixRelabel.NMixMCMC}
\title{
  Re-labeling the MCMC output of the mixture model
}
\description{
  This function takes an object generated by the \code{\link{NMixMCMC}}
  or \code{\link{GLMM_MCMC}} function and internally re-labels the mixture
  components using selected re-labeling algorithm. It also computes
  posterior summary statistics for mixture means, weights, variances
  which correspond to newly labeled MCMC sample. Further, posterior
  component probabilities (\code{poster.comp.prob1} and
  \code{poster.comp.prob2} components of the object \code{object}) are
  updated according to the newly labeled MCMC sample.

  This function only works for models with a fixed number of mixture components.
}
\usage{
NMixRelabel(object, type=c("mean", "weight", "stephens"), par, \dots)

\method{NMixRelabel}{default}(object, type=c("mean", "weight", "stephens"), par, \dots)

\method{NMixRelabel}{NMixMCMC}(object, type=c("mean", "weight", "stephens"), par, info, \dots)
}
\arguments{
  \item{object}{an object of apropriate class (currently only class
    \code{NMixMCMC} is implemented).}
  \item{type}{character string which specifies the type of the
    re-labeling algorithm.}
  \item{par}{additional parameters for particular re-labeling
    algorithms.

    \describe{
      \item{mean}{\code{par} specifies margin which is used to order the
	components. It is set to 1 if not given.}
      \item{weight}{\code{par} is empty.}
      \item{stephens}{\code{par} is a list with components
        \code{type.init}, \code{par}, \code{maxiter}.

        Component \code{type.init} is a character string being equal to
	either of \dQuote{identity}, \dQuote{mean}, \dQuote{weight}. It
	determines the way which is used to obtain initial re-labeling.

	Component \code{par} determines the margin in the case that
	\code{type.init} is equal to \dQuote{mean}.

	Component \code{maxiter} determines maximum number of iterations
	of the re-labeling algorithm.		
      }
    }  
  }
  \item{info}{number which specifies frequency used to re-display the
    iteration counter during the computation.
  }
  \item{\dots}{optional additional arguments.}
}  
\value{
  An object being equal to the value of the \code{object} argument in
  which the following components are updated according to new labeling
  of the mixture components.
}
\section{Value for NMixMCMC object}{
  When the argument \code{object} is of class \code{NMixMCMC}, the
  resulting object is equal to \code{object} with the following
  components being modified:
  \describe{
    \item{relabel}{see \code{\link{NMixMCMC}}}
    \item{order}{see \code{\link{NMixMCMC}}}
    \item{rank}{see \code{\link{NMixMCMC}}}
    \item{poster.mean.w}{see \code{\link{NMixMCMC}}}
    \item{poster.mean.mu}{see \code{\link{NMixMCMC}}}
    \item{poster.mean.Q}{see \code{\link{NMixMCMC}}}
    \item{poster.mean.Sigma}{see \code{\link{NMixMCMC}}}
    \item{poster.mean.Li}{see \code{\link{NMixMCMC}}}
    \item{poster.comp.prob1}{see \code{\link{NMixMCMC}}}
    \item{poster.comp.prob2}{see \code{\link{NMixMCMC}}}
  }
}  
\references{
  Celeux, G. (1998).
  Bayesian inference for mixtures: The label-switching problem.
  In: \emph{COMPSTAT 98} (eds. R. Payne and P. Green),
  pp. 227-232. Heidelberg: Physica-Verlag.

  Jasra, A., Holmes, C. C., and Stephens, D. A. (2005).
  Markov chain Monte Carlo methods and the label switching problem in
  Bayesian mixture modeling.
  \emph{Statistical Science}, \bold{20}, 50-67.
  
  Stephens, M. (1997).
  \emph{Bayesian methods for mixtures of normal distributions. DPhil Thesis.}
  Oxford: University of Oxford.
  (Available from (as of 08/02/2010):
  \url{http://www.stat.washington.edu/stephens/papers.html}).
  
  Stephens, M. (2000).
  Dealing with label switching in mixture models.
  \emph{Journal of the Royal Statistical Society, Series B}, \bold{62}, 795-809.
}
\seealso{
  \code{\link{NMixMCMC}}, \code{\link{GLMM_MCMC}}.
}
\author{
  \eqn{\mbox{Arno\v{s}t Kom\'arek}}{Arno&#353t Kom&#225rek} \email{arnost.komarek[AT]mff.cuni.cz}
}  
\examples{
## TO BE ADDED.
}
\keyword{multivariate}
\keyword{cluster}
