% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dist_SimuChisq.R
\name{Dist_SimuChisq}
\alias{Dist_SimuChisq}
\title{Build a simulated distribution for Chi-Square}
\usage{
Dist_SimuChisq(s,prob,b)
}
\arguments{
\item{s}{a matrix of frequencies for each simulated sample. Each row for each sample.}

\item{prob}{a vector of expected probability for each simulated sample.}

\item{b}{the times of bootstrapping.}
}
\value{
a vector of Chi-square statistics, length is the times of sampling.
}
\description{
Build a simulated distribution for Chi-Square
}
\details{
This function build the distribution of Chi square statistics for simulated samples
}
\examples{
require(mixIndependR)
h<-runif(10)
s<-Simulate_DistK(h,500,100)
Exp <- DistHetero(h)
Dist_SimuChisq(s,Exp$Density,10)
}
