% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixRaschTools.R
\name{Average Ability Levels for Multiple Class Mixed Rasch Model}
\alias{Average Ability Levels for Multiple Class Mixed Rasch Model}
\alias{avg.theta}
\title{Average Ability Levels for Multiple Class Mixed Rasch Model}
\usage{
avg.theta(x)
}
\arguments{
\item{x}{A fitted multiple class mixture Rasch model}
}
\description{
This function produces mean ability levels for each class in a mixture Rasch model.
}
\details{
mixRaschTools Average Theta -----------------------------------------------------------

This function produces a matrix containing the average theta values for each latent class
included in mixture Rasch model.
}
\examples{
##Example multiple class mixture Rasch models included with mixRaschToolkit
data(threeclass_ex)
##Average Theta Values
avg.theta(threeclass_ex)
}
\references{
Willse, J. T. (2011). Mixture Rasch models with joint maximum likelihood estimation. Educational and Psychological Measurement, 71, 5-19, https://doi.org/10.1177/0013164410387335
}
\author{
Pamela S Trantham
}
