% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\docType{methods}
\name{getM2}
\alias{getM2}
\alias{getM2,MizerParams,missing,missing,array-method}
\alias{getM2,MizerParams,matrix,numeric,missing-method}
\alias{getM2,MizerSim,missing,missing,missing-method}
\title{getM2 method for the size based model}
\usage{
getM2(object, n, n_pp, pred_rate, ...)

\S4method{getM2}{MizerParams,missing,missing,array}(object, pred_rate)

\S4method{getM2}{MizerParams,matrix,numeric,missing}(object, n, n_pp)

\S4method{getM2}{MizerSim,missing,missing,missing}(object,
  time_range = dimnames(object@n)$time, drop = TRUE, ...)
}
\arguments{
\item{object}{A \code{MizerParams} or \code{MizerSim} object.}

\item{n}{A matrix of species abundance (species x size). Only used if
\code{object} argument is of type \code{MizerParams}.}

\item{n_pp}{A vector of the background abundance by size. Only used if
\code{object} argument is of type \code{MizerParams}.}

\item{pred_rate}{An array of predation rates of dimension no. sp x no.
community size bins x no. of size bins in whole spectra (i.e. community +
background, the w_full slot). The array is optional. If it is not provided
it is calculated by the \code{getPredRate()} method.}

\item{...}{Other arguments (currently unused).}

\item{time_range}{Subset the returned fishing mortalities by time. The time
range is either a vector of values, a vector of min and max time, or a
single value. Default is the whole time range. Only used if the
\code{object} argument is of type \code{MizerSim}.}

\item{drop}{Only used when object is of type \code{MizerSim}. Should
dimensions of length 1 in the output be dropped, simplifying the output.
Defaults to TRUE}
}
\value{
If a \code{MizerParams} object is passed in, the method returns a two
  dimensional array (prey species x prey size) based on the abundances also
  passed in. If a \code{MizerSim} object is passed in, the method returns a
  three dimensional array (time step x prey species x prey size) with the
  predation mortality calculated at every time step in the simulation.
}
\description{
Calculates the total predation mortality rate \eqn{\mu_{p,i}(w_p)} on each prey
species by prey size. This method is used by the \code{\link{project}} method
for performing simulations.

\code{getM2} method for \code{MizerParams} object with \code{pred_rate} argument.

\code{getM2} method for \code{MizerParams} object without \code{pred_rate} argument.

\code{getM2} method for \code{MizerSim} object.
}
\examples{
\dontrun{
data(NS_species_params_gears)
data(inter)
params <- MizerParams(NS_species_params_gears, inter)
# With constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
# Get M2 at one time step
n <- sim@n[21,,]
n_pp <- sim@n_pp[21,]
getM2(params,n,n_pp)
# Get M2 at all saved time steps
getM2(sim)
# Get M2 over the time 15 - 20
getM2(sim, time_range = c(15,20))
}
}
\seealso{
\code{\link{getPredRate}} and \code{\link{project}}.
}
