% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\docType{methods}
\name{getM2Background}
\alias{getM2Background}
\alias{getM2Background,MizerParams,matrix,numeric,array-method}
\alias{getM2Background,MizerParams,matrix,numeric,missing-method}
\title{Get predation mortality rate for plankton}
\usage{
getM2Background(object, n, n_pp, pred_rate)

\S4method{getM2Background}{MizerParams,matrix,numeric,array}(object, n,
  n_pp, pred_rate)

\S4method{getM2Background}{MizerParams,matrix,numeric,missing}(object, n,
  n_pp, pred_rate)
}
\arguments{
\item{object}{A \code{MizerParams} object.}

\item{n}{A matrix of species abundance (species x size).}

\item{n_pp}{A vector of the background abundance by size.}

\item{pred_rate}{An array of predation rates of dimension no. sp x no.
community size bins x no. of size bins in whole spectra (i.e. community +
background, the w_full slot). The array is optional. If it is not provided
it is calculated by the \code{getPredRate()} method.}
}
\value{
A vector of predation mortalities by background prey size.
}
\description{
Calculates the predation mortality rate \eqn{\mu_p(w)} on the plankton
spectrum by plankton size. Used by the \code{project} method for running size
based simulations.
}
\examples{
\dontrun{
data(NS_species_params_gears)
data(inter)
params <- MizerParams(NS_species_params_gears, inter)
# With constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
# Get M2 of the background spectrum at one time step
n <- sim@n[21,,]
n_pp <- sim@n_pp[21,]
getM2Background(params,n,n_pp)
}
}
\seealso{
\code{\link{project}} and \code{\link{getM2}}.
}
