% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_functions.R
\name{retune_abundance}
\alias{retune_abundance}
\title{Retunes abundance of background species.}
\usage{
retune_abundance(params, retune)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{retune}{A boolean vector that determines whether a species can be 
retuned or not.}
}
\value{
An object of type \code{MizerParams}
}
\description{
An unexported helper function.
}
\details{
If N_i(w) is a steady state of the McKendrik-von Foerster (MVF) equation with
fixed growth and death rates, then A_i*N_i(w) is also a steady state, where
A_i is an abundance multiplier. When we add a foreground species to our
model, we want to choose new abundance multipliers of the background species
so that the community abundance after adding the new species is close to
the original community abundance, stored in \code{params@sc}.
}
\seealso{
\linkS4class{MizerParams}
}
