% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newSingleSpeciesParams.R
\name{newSingleSpeciesParams}
\alias{newSingleSpeciesParams}
\title{Set up parameters for a single species in a power-law background}
\usage{
newSingleSpeciesParams(
  species_name = "Target species",
  w_inf = 100,
  w_min = 0.001,
  eta = 10^(-0.6),
  w_mat = w_inf * eta,
  no_w = log10(w_inf/w_min) * 20 + 1,
  n = 3/4,
  p = n,
  lambda = 2.05,
  kappa = 0.005,
  alpha = 0.4,
  k_vb = 1,
  beta = 100,
  sigma = 1.3,
  f0 = 0.6,
  fc = 0.25,
  ks = NA,
  gamma = NA,
  ext_mort_prop = 0,
  reproduction_level = 0,
  R_factor = deprecated()
)
}
\arguments{
\item{species_name}{A string with a name for the species. Will be used in
plot legends.}

\item{w_inf}{Asymptotic size of species}

\item{w_min}{Egg size of species}

\item{eta}{Ratio between maturity size \code{w_mat} and asymptotic size
\code{w_inf}. Default is 10^(-0.6), approximately 1/4. Ignored if
\code{w_mat} is supplied explicitly.}

\item{w_mat}{Maturity size of species. Default value is
\code{eta * w_inf}.}

\item{no_w}{The number of size bins in the community spectrum. These bins
will be equally spaced on a logarithmic scale. Default value is such that
there are 20 bins for each factor of 10 in weight.}

\item{n}{Scaling exponent of the maximum intake rate.}

\item{p}{Scaling exponent of the standard metabolic rate. By default this is
equal to the exponent \code{n}.}

\item{lambda}{Exponent of the abundance power law.}

\item{kappa}{Coefficient in abundance power law.}

\item{alpha}{The assimilation efficiency.}

\item{k_vb}{The von Bertalanffy growth parameter.}

\item{beta}{Preferred predator prey mass ratio.}

\item{sigma}{Width of prey size preference.}

\item{f0}{Expected average feeding level. Used to set \code{gamma}, the
coefficient in the search rate. Ignored if \code{gamma} is given
explicitly.}

\item{fc}{Critical feeding level. Used to determine \code{ks} if it is not given
explicitly.}

\item{ks}{Standard metabolism coefficient. If not provided, default will be
calculated from critical feeding level argument \code{fc}.}

\item{gamma}{Volumetric search rate. If not provided, default is determined
by \code{\link[=get_gamma_default]{get_gamma_default()}} using the value of \code{f0}.}

\item{ext_mort_prop}{The proportion of the total mortality that comes from
external mortality, i.e., from sources not explicitly modelled. A number in
the interval [0, 1).}

\item{reproduction_level}{A number between 0 an 1 that determines the
level of density dependence in reproduction, see \code{\link[=setBevertonHolt]{setBevertonHolt()}}.}

\item{R_factor}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use
\code{reproduction_level = 1 / R_factor} instead.}
}
\value{
An object of type \code{MizerParams}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This functions creates a \code{MizerParams} object with a single
species. This species is embedded in a fixed power-law community spectrum
\deqn{N_c(w) = \kappa w^{-\lambda}}
This community provides the food income for the species. Cannibalism is
switched off. The predation mortality arises only from the predators in the
power-law community and it is assumed that the predators in the community
have the same feeding parameters as the foreground species. The function has
many arguments, all of which have default values.
}
\details{
In addition to setting up the parameters, this function also sets up an
initial condition that is close to steady state, under the assumption of
no fishing.
}
\examples{
params <- newSingleSpeciesParams()
sim <- project(params, t_max = 5, effort = 0)
plotSpectra(sim)
}
\seealso{
Other functions for setting up models: 
\code{\link{newCommunityParams}()},
\code{\link{newMultispeciesParams}()},
\code{\link{newTraitParams}()}
}
\concept{functions for setting up models}
