% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dis_2dsvd.R
\encoding{UTF-8}
\name{dis_2dsvd}
\alias{dis_2dsvd}
\title{Constructs a pairwise distance matrix based on two-dimensional singular
value decomposition (2dSVD)}
\usage{
dis_2dsvd(X, var_u = 0.9, var_v = 0.9, features = FALSE)
}
\arguments{
\item{X}{A list of MTS (numerical matrices).}

\item{var_u}{Rate of retained variability concerning the row-row covariance
matrix.}

\item{var_v}{Rate of retained variability concerning the column-column
covariance matrix.}

\item{features}{Logical. If \code{features = FALSE} (default), a distance matrix is returned. Otherwise, the function
returns a dataset of feature vectors.}
}
\value{
If \code{features = FALSE} (default), returns a distance matrix based on the distance \eqn{d_{2dSVD}}. Otherwise, the function
returns a dataset of feature vectors, i.e., each row in the dataset contains the features employed to compute the
distance \eqn{d_{2dSVD}}.
}
\description{
\code{dis_2dsvd} returns a pairwise distance matrix based on the 2dSVD
distance measure proposed by \insertCite{weng2008classification;textual}{mlmts}.
}
\details{
Given a collection of MTS, the function returns the pairwise distance matrix,
where the distance between two MTS \eqn{\boldsymbol X_T^{(1)}} and \eqn{\boldsymbol X_T^{(2)}} is defined
as  \deqn{d_{Eros}(\boldsymbol X_T^{(1)}, \boldsymbol X_T^{(2)}}
}
\examples{
toy_dataset <- BasicMotions$data[1 : 10] # Selecting the first 10 MTS from the
# dataset BasicMotions
distance_matrix <- dis_2dsvd(toy_dataset) # Computing the pairwise
# distance matrix based on the distance dis_2dsvd
feature_dataset <- dis_2dsvd(toy_dataset, features = TRUE) # Computing
# the corresponding dataset of features
}
\references{
{

  \insertRef{weng2008classification}{mlmts}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
