% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_converters.R
\name{convert_task}
\alias{convert_task}
\title{Convert a Task from One Type to Another}
\usage{
convert_task(
  intask,
  target = NULL,
  new_type = NULL,
  drop_original_target = FALSE,
  drop_levels = TRUE
)
}
\arguments{
\item{intask}{(\link{Task})\cr
A \link{Task} to be converted.}

\item{target}{(\code{character(1)})\cr
New target to be set, must be a column in the \code{intask} data.
If \code{NULL}, no new target is set, and task is converted as-is.}

\item{new_type}{(\code{character(1)})\cr
The new task type. Must be in \code{\link[=mlr_reflections]{mlr_reflections$task_types}}].
If \code{NULL} (default), a new task with the same task_type is created.}

\item{drop_original_target}{(\code{logical(1)})\cr
If \code{FALSE} (default), the original target is added as a feature.
Otherwise the original target is dropped.}

\item{drop_levels}{(\code{logical(1)})\cr
If \code{TRUE} (default), unused levels of the new target variable are dropped.}
}
\value{
\link{Task} of requested type.
}
\description{
The task's target is replaced by a different column from the data.
}
