% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Filter.R
\docType{data}
\name{Filter}
\alias{Filter}
\title{Filter Base Class}
\format{\link[R6:R6Class]{R6::R6Class} object.}
\description{
Base class for filters. Predefined filters are stored in the
\link[mlr3misc:Dictionary]{dictionary} \link{mlr_filters}. A Filter calculates a score
for each feature of a task. Important features get a large value and
unimportant features get a small value. Note that filter scores may also be
negative.
}
\section{Construction}{
\preformatted{f = Filter$new(id, task_type, param_set, param_vals, feature_types, packages)
}
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier for the filter.
\item \code{task_type} :: \code{character()}\cr
Types of the task the filter can operator on. E.g., \code{"classif"} or \code{"regr"}.
\item \code{param_set} :: \link[paradox:ParamSet]{paradox::ParamSet}\cr
Set of hyperparameters.
\item \code{param_vals} :: named \code{list()}\cr
Named list of hyperparameter settings.
\item \code{feature_types} :: \code{character()}\cr
Feature types the filter operates on.
Must be a subset of \code{\link[mlr3:mlr_reflections]{mlr_reflections$task_feature_types}}.
\item \code{task_properties} :: \code{character()}\cr
Required task properties, see \link[mlr3:Task]{mlr3::Task}.
Must be a subset of \code{\link[mlr3:mlr_reflections]{mlr_reflections$task_properties}}.
\item \code{packages} :: \code{character()}\cr
Set of required packages.
Note that these packages will be loaded via \code{\link[=requireNamespace]{requireNamespace()}}, and are not attached.
}
}

\section{Fields}{


All arguments passed to the constructor are available as fields, and additionally:
\itemize{
\item \code{scores} :: named \code{numeric()}\cr
Stores the calculated filter score values as named numeric vector.
The vector is sorted in decreasing order with possible \code{NA} values last.
Tied values (this includes \code{NA} values) appear in a random, non-deterministic order.
}
}

\section{Methods}{

\itemize{
\item \code{calculate(task, nfeat = NULL)}\cr
(\link[mlr3:Task]{mlr3::Task}, \code{integer(1)}) -> \code{self}\cr
Calculates the filter score values for the provided \link[mlr3:Task]{mlr3::Task} and stores them in field \code{scores}.
\code{nfeat} determines the minimum number of features to score (see "Partial Scoring"), and defaults to the number of features in \code{task}.
Loads required packages and then calls \code{$calculate_internal()}.
If the task has no rows, each feature gets the score \code{NA}.
\item \code{calculate_internal(task, nfeat)}\cr
(\link[mlr3:Task]{mlr3::Task}, \code{integer(1)}) -> named \code{numeric()}\cr
Internal worker function. Each child class muss implement this method.
Takes a task and the minimum number of features to score, and must return a named numeric with scores.
The higher the score, the more important the feature.
The calling function (\code{calculate()}) ensures that the returned vector gets sorted and that missing feature scores get a score value of \code{NA}.
}
}

\section{Partial Scoring}{

Some features support partial scoring of the feature set:
If \code{nfeat} is not \code{NULL}, only the best \code{nfeat} features are guaranteed to get a score.
Additional features may be ignored for computational reasons, and then get a score value of \code{NA}.
}

\seealso{
Other Filter: \code{\link{FilterAUC}},
  \code{\link{FilterAnova}}, \code{\link{FilterCMIM}},
  \code{\link{FilterCarScore}},
  \code{\link{FilterCorrelation}},
  \code{\link{FilterDISR}}, \code{\link{FilterImportance}},
  \code{\link{FilterInformationGain}},
  \code{\link{FilterJMIM}}, \code{\link{FilterJMI}},
  \code{\link{FilterKruskalTest}}, \code{\link{FilterMIM}},
  \code{\link{FilterMRMR}}, \code{\link{FilterNJMIM}},
  \code{\link{FilterPerformance}},
  \code{\link{FilterVariance}}, \code{\link{mlr_filters}}
}
\concept{Filter}
\keyword{datasets}
