% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterKruskalTest.R
\name{FilterKruskalTest}
\alias{FilterKruskalTest}
\alias{mlr_filters_kruskal_test}
\title{Kruskal-Wallis Test Filter}
\format{\link[R6:R6Class]{R6::R6Class} inheriting from \link{Filter}.}
\description{
Kruskal-Wallis rank sum test filter calling \code{\link[stats:kruskal.test]{stats::kruskal.test()}}.

The filter value is \code{-log10(p)} where \code{p} is the \eqn{p}-value. This transformation
is necessary to ensure numerical stability for very small \eqn{p}-values.
}
\section{Construction}{
\preformatted{FilterKruskalTest$new()
mlr_filters$get("kruskal_test")
flt("kruskal_test")
}
}

\examples{
task = mlr3::tsk("iris")
filter = flt("kruskal_test")
filter$calculate(task)
as.data.table(filter)

# transform to p-value
10^(-filter$scores)
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Filter]{Filters}: \link{mlr_filters}

Other Filter: 
\code{\link{FilterAUC}},
\code{\link{FilterAnova}},
\code{\link{FilterCMIM}},
\code{\link{FilterCarScore}},
\code{\link{FilterCorrelation}},
\code{\link{FilterDISR}},
\code{\link{FilterImportance}},
\code{\link{FilterInformationGain}},
\code{\link{FilterJMIM}},
\code{\link{FilterJMI}},
\code{\link{FilterMIM}},
\code{\link{FilterMRMR}},
\code{\link{FilterNJMIM}},
\code{\link{FilterPerformance}},
\code{\link{FilterVariance}},
\code{\link{Filter}},
\code{\link{mlr_filters}}
}
\concept{Filter}
