% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerClassifMultinom.R
\name{mlr_learners_classif.multinom}
\alias{mlr_learners_classif.multinom}
\alias{LearnerClassifMultinom}
\title{Multinomial log-linear learner via neural networks}
\description{
Multinomial log-linear models via neural networks.
Calls \code{\link[nnet:multinom]{nnet::multinom()}} from package \CRANpkg{nnet}.
}
\section{Dictionary}{

This \link{Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_learners} or with the associated sugar function \code{\link[=lrn]{lrn()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_learners$get("classif.multinom")
lrn("classif.multinom")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

, * Task type: \dQuote{classif}, * Predict Types: \dQuote{response}, \dQuote{prob}, * Feature Types: \dQuote{logical}, \dQuote{integer}, \dQuote{numeric}, \dQuote{factor}, * Required Packages: \CRANpkg{mlr3}, \CRANpkg{mlr3learners}, \CRANpkg{nnet}
}

\section{Parameters}{

, |Id       |Type      |Default |Levels      |Range                                |, |:--------|:---------|:-------|:-----------|:------------------------------------|, |Hess     |logical   |FALSE   |TRUE, FALSE |-                                    |, |abstol   |numeric   |1e-04   |            |\eqn{(-\infty, \infty)}{(-Inf, Inf)} |, |censored |logical   |FALSE   |TRUE, FALSE |-                                    |, |decay    |numeric   |0       |            |\eqn{(-\infty, \infty)}{(-Inf, Inf)} |, |entropy  |logical   |FALSE   |TRUE, FALSE |-                                    |, |mask     |untyped   |-       |            |-                                    |, |maxit    |integer   |100     |            |\eqn{[1, \infty)}{[1, Inf)}          |, |MaxNWts  |integer   |1000    |            |\eqn{[1, \infty)}{[1, Inf)}          |, |model    |logical   |FALSE   |TRUE, FALSE |-                                    |, |linout   |logical   |FALSE   |TRUE, FALSE |-                                    |, |rang     |numeric   |0.7     |            |\eqn{(-\infty, \infty)}{(-Inf, Inf)} |, |reltol   |numeric   |1e-08   |            |\eqn{(-\infty, \infty)}{(-Inf, Inf)} |, |size     |integer   |-       |            |\eqn{[1, \infty)}{[1, Inf)}          |, |skip     |logical   |FALSE   |TRUE, FALSE |-                                    |, |softmax  |logical   |FALSE   |TRUE, FALSE |-                                    |, |summ     |character |0       |0, 1, 2, 3  |-                                    |, |trace    |logical   |TRUE    |TRUE, FALSE |-                                    |, |Wts      |untyped   |-       |            |-                                    |
}

\examples{
if (requireNamespace("nnet", quietly = TRUE)) {
  learner = mlr3::lrn("classif.multinom")
  print(learner)

  # available parameters:
learner$param_set$ids()
}
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/basics.html#learners}
\item Package \href{https://github.com/mlr-org/mlr3extralearners}{mlr3extralearners} for more learners.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Learner]{Learners}: \link{mlr_learners}
\item \code{as.data.table(mlr_learners)} for a table of available \link[=Learner]{Learners} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3pipelines} to combine learners with pre- and postprocessing steps.
\item Extension packages for additional task types:
\itemize{
\item \CRANpkg{mlr3proba} for probabilistic supervised regression and survival analysis.
\item \CRANpkg{mlr3cluster} for unsupervised clustering.
}
\item \CRANpkg{mlr3tuning} for tuning of hyperparameters, \CRANpkg{mlr3tuningspaces}
for established default tuning spaces.
}

Other Learner: 
\code{\link{mlr_learners_classif.cv_glmnet}},
\code{\link{mlr_learners_classif.glmnet}},
\code{\link{mlr_learners_classif.kknn}},
\code{\link{mlr_learners_classif.lda}},
\code{\link{mlr_learners_classif.log_reg}},
\code{\link{mlr_learners_classif.naive_bayes}},
\code{\link{mlr_learners_classif.nnet}},
\code{\link{mlr_learners_classif.qda}},
\code{\link{mlr_learners_classif.ranger}},
\code{\link{mlr_learners_classif.svm}},
\code{\link{mlr_learners_classif.xgboost}},
\code{\link{mlr_learners_regr.cv_glmnet}},
\code{\link{mlr_learners_regr.glmnet}},
\code{\link{mlr_learners_regr.kknn}},
\code{\link{mlr_learners_regr.km}},
\code{\link{mlr_learners_regr.lm}},
\code{\link{mlr_learners_regr.ranger}},
\code{\link{mlr_learners_regr.svm}},
\code{\link{mlr_learners_regr.xgboost}}
}
\concept{Learner}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3:LearnerClassif]{mlr3::LearnerClassif}} -> \code{LearnerClassifMultinom}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerClassifMultinom-new}{\code{LearnerClassifMultinom$new()}}
\item \href{#method-LearnerClassifMultinom-loglik}{\code{LearnerClassifMultinom$loglik()}}
\item \href{#method-LearnerClassifMultinom-clone}{\code{LearnerClassifMultinom$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format"><a href='../../mlr3/html/Learner.html#method-Learner-format'><code>mlr3::Learner$format()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print"><a href='../../mlr3/html/Learner.html#method-Learner-print'><code>mlr3::Learner$print()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset"><a href='../../mlr3/html/Learner.html#method-Learner-reset'><code>mlr3::Learner$reset()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClassifMultinom-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClassifMultinom-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClassifMultinom$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClassifMultinom-loglik"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClassifMultinom-loglik}{}}}
\subsection{Method \code{loglik()}}{
Extract the log-likelihood (e.g., via \code{\link[stats:logLik]{stats::logLik()}} from the fitted model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClassifMultinom$loglik()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClassifMultinom-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClassifMultinom-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClassifMultinom$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
