% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_mcc.R
\name{mcc}
\alias{mcc}
\title{Matthews Correlation Coefficient}
\usage{
mcc(truth, response, positive, ...)
}
\arguments{
\item{truth}{:: \code{factor()}\cr
True (observed) labels.
Must have exactly same two levels and the same length as \code{response}.}

\item{response}{:: \code{factor()}\cr
Predicted response labels.
Must have exactly same two levels and the same length as \code{truth}.}

\item{positive}{:: \code{character(1)}\cr
Name of the positive class.}

\item{...}{:: \code{any}\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Binary classification measure defined as \deqn{
   \frac{\mathrm{TP} \cdot \mathrm{TN} - \mathrm{FP} \cdot \mathrm{FN}}{\sqrt{(\mathrm{TP} + \mathrm{FP}) (\mathrm{TP} + \mathrm{FN}) (\mathrm{TN} + \mathrm{FP}) (\mathrm{TN} + \mathrm{FN})}}.
}{
   (TP * TN - FP * FN) / sqrt((TP + FP) * (TP + FN) * (TN + FP) * (TN + FN)).
}
}
\note{
This measure is undefined if any of the four sums in the denominator is 0.
The denominator is then set to 1.
}
\section{Meta Information}{

\itemize{
\item Type: \code{"binary"}
\item Range: \eqn{[-1, 1]}{[-1, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{response}
}
}

\examples{
set.seed(1)
lvls = c("a", "b")
truth = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
response = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
mcc(truth, response, positive = "a")
}
\references{
\cite{matthews_1975}
}
\seealso{
Other Binary Classification Measures: \code{\link{auc}},
  \code{\link{dor}}, \code{\link{fbeta}},
  \code{\link{fdr}}, \code{\link{fnr}}, \code{\link{fn}},
  \code{\link{fomr}}, \code{\link{fpr}}, \code{\link{fp}},
  \code{\link{npv}}, \code{\link{ppv}}, \code{\link{tnr}},
  \code{\link{tn}}, \code{\link{tpr}}, \code{\link{tp}}
}
\concept{Binary Classification Measures}
\concept{binary_classification_measure}
