% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_graphs_elements.R
\name{mlr_graphs_robustify}
\alias{mlr_graphs_robustify}
\alias{pipeline_robustify}
\title{Robustify a learner}
\usage{
pipeline_robustify(
  task = NULL,
  learner = NULL,
  impute_missings = NULL,
  factors_to_numeric = NULL,
  max_cardinality = 1000
)
}
\arguments{
\item{task}{\code{\link{Task}} \cr
A \code{\link[mlr3:Task]{Task}} to create a robustifying pipeline for.
Optional, if omitted, the full pipeline is created.}

\item{learner}{\code{\link[mlr3:Learner]{Learner}} \cr
A learner to create a robustifying pipeline for. Optional, if omitted,
a more conservative pipeline is built.}

\item{impute_missings}{\code{logical(1)} | \code{NULL} \cr
Should missing values be imputed? Defaults to \code{NULL}, i.e. imputes if the task has
missing values and the learner can not handle them.}

\item{factors_to_numeric}{\code{logical(1)} | \code{NULL} \cr
Should factors be encoded? Defaults to \code{NULL}, i.e. encodes if the task has factors
and the learner can not handle factors.}

\item{max_cardinality}{\code{integer(1)} \cr
Maximum number of factor levels allowed. See above. Default: 1000.}
}
\value{
\code{\link{Graph}}
}
\description{
Creates a \code{\link{Graph}} that can be used to robustify any subsequent learner.
Performs the following steps:
\itemize{
\item Drops empty factor levels using \code{\link{PipeOpFixFactors}}
\item Imputes \code{numeric} features using \code{\link{PipeOpImputeHist}} and \code{\link{PipeOpMissInd}}
\item Imputes \code{factor} features using \code{\link{PipeOpImputeOOR}}
\item Encodes \code{factors} using \code{one-hot-encoding}. Factors with a cardinality > max_cardinality are
collapsed using \code{\link{PipeOpCollapseFactors}}
\item If \code{scaling}, numeric features are scaled to mean 0 and standard deviation 1
}

The graph is built conservatively, i.e. the function always tries to assure everything works.
If a learner is provided, some steps can be left out, i.e. if the learner can deal with
factor variables, no encoding is performed.
}
\examples{
\donttest{
library(mlr3)
lrn = lrn("regr.rpart")
task = mlr_tasks$get("boston_housing")
gr = pipeline_robustify(task, lrn) \%>>\% po("learner", lrn)
resample(task, GraphLearner$new(gr), rsmp("holdout"))
}
}
