% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpImputeLearner.R
\name{mlr_pipeops_imputelearner}
\alias{mlr_pipeops_imputelearner}
\alias{PipeOpImputeLearner}
\title{Impute Features by Fitting a Learner}
\format{
\code{\link{R6Class}} object inheriting from \code{\link{PipeOpImpute}}/\code{\link{PipeOp}}.
}
\description{
Impute features by fitting a \code{\link[mlr3:Learner]{Learner}} for each feature.
Uses the features indicated by the \code{context_columns} parameter as features to train the imputation \code{\link[mlr3:Learner]{Learner}}.
Note this parameter is part of the \code{\link{PipeOpImpute}} base class and explained there.

Additionally, only features supported by the learner can be imputed; i.e. learners of type
\code{regr} can only impute features of type \code{integer} and \code{numeric}, while \code{classif} can impute
features of type \code{factor}, \code{ordered} and \code{logical}.

The \code{\link[mlr3:Learner]{Learner}} used for imputation is trained on all \code{context_columns}; if these contain missing values,
the \code{\link[mlr3:Learner]{Learner}} typically either needs to be able to handle missing values itself, or needs to do its
own imputation (see examples).
}
\section{Construction}{
\preformatted{PipeOpImputeLearner$new(learner, id = NULL, param_vals = list())
}
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier of resulting object, default \code{"impute."}, followed by the \code{id} of the \code{Learner}.
\item \code{learner} :: \code{\link[mlr3:Learner]{Learner}} | \code{character(1)}
\code{\link[mlr3:Learner]{Learner}} to wrap, or a string identifying a \code{\link[mlr3:Learner]{Learner}} in the \code{\link[mlr3:mlr_learners]{mlr3::mlr_learners}} \code{\link[mlr3misc:Dictionary]{Dictionary}}.
The \code{\link[mlr3:Learner]{Learner}} usually needs to be able to handle missing values, i.e. have the \code{missings} property, unless care is taken
that \code{context_columns} do not contain missings; see examples.\cr
This argument is always cloned; to access the \code{\link[mlr3:Learner]{Learner}} inside \code{PipeOpImputeLearner} by-reference, use \verb{$learner}.\cr
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

Input and output channels are inherited from \code{\link{PipeOpImpute}}.

The output is the input \code{\link[mlr3:Task]{Task}} with missing values from all affected features imputed by the trained model.
}

\section{State}{

The \verb{$state} is a named \code{list} with the \verb{$state} elements inherited from \code{\link{PipeOpImpute}}.

The \verb{$state$models} is a named \code{list} of \code{models} created by the \code{\link[mlr3:Learner]{Learner}}'s \verb{$.train()} function
for each column. If a column consists of missing values only during training, the \code{model} is \code{0} or the levels of the
feature; these are used for sampling during prediction.
}

\section{Parameters}{

The parameters are the parameters inherited from \code{\link{PipeOpImpute}}, in addition to the parameters of the \code{\link[mlr3:Learner]{Learner}}
used for imputation.
}

\section{Internals}{

Uses the \verb{$train} and \verb{$predict} functions of the provided learner. Features that are entirely \code{NA} are imputed as \code{0}
or randomly sampled from available (\code{factor} / \code{logical}) levels.

The \code{\link[mlr3:Learner]{Learner}} does \emph{not} necessarily need to handle missing values in cases
where \code{context_columns} is chosen well (or there is only one column with missing values present).
}

\section{Fields}{

Fields inherited from \code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}, as well as:
\itemize{
\item \code{learner} :: \code{\link[mlr3:Learner]{Learner}}\cr
\code{\link[mlr3:Learner]{Learner}} that is being wrapped. Read-only.
\item \code{learner_models} :: \code{list} of \code{\link[mlr3:Learner]{Learner}} | \code{NULL}\cr
\code{\link[mlr3:Learner]{Learner}} that is being wrapped. This list is named by features for which a \code{Learner} was fitted, and
contains the same \code{Learner}, but with different respective models for each feature. If this \code{PipeOp} is not trained,
this is an empty \code{list}. For features that were entirely \code{NA} during training, the \code{list} contains \code{NULL} elements.
}
}

\section{Methods}{

Only methods inherited from \code{\link{PipeOpImpute}}/\code{\link{PipeOp}}.
}

\examples{
library("mlr3")

task = tsk("pima")
task$missings()

po = po("imputelearner", lrn("regr.rpart"))
new_task = po$train(list(task = task))[[1]]
new_task$missings()

# '$state' of the "regr.rpart" Learner, trained to predict the 'mass' column:
po$state$model$mass

library("mlr3learners")
# to use the "regr.kknn" Learner, prefix it with its own imputation method!
# The "imputehist" PipeOp is used to train "regr.kknn"; predictions of this
# trained Learner are then used to impute the missing values in the Task.
po = po("imputelearner",
  po("imputehist") \%>>\% lrn("regr.kknn")
)

new_task = po$train(list(task = task))[[1]]
new_task$missings()

}
\seealso{
https://mlr3book.mlr-org.com/list-pipeops.html

Other PipeOps: 
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpTargetTrafo}},
\code{\link{PipeOpTaskPreprocSimple}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOp}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_colroles}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_datefeatures}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputeconstant}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputemode}},
\code{\link{mlr_pipeops_imputeoor}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nmf}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_proxy}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_randomprojection}},
\code{\link{mlr_pipeops_randomresponse}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_renamecolumns}},
\code{\link{mlr_pipeops_replicate}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_targetinvert}},
\code{\link{mlr_pipeops_targetmutate}},
\code{\link{mlr_pipeops_targettrafoscalerange}},
\code{\link{mlr_pipeops_textvectorizer}},
\code{\link{mlr_pipeops_threshold}},
\code{\link{mlr_pipeops_tunethreshold}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_updatetarget}},
\code{\link{mlr_pipeops_vtreat}},
\code{\link{mlr_pipeops_yeojohnson}},
\code{\link{mlr_pipeops}}

Other Imputation PipeOps: 
\code{\link{PipeOpImpute}},
\code{\link{mlr_pipeops_imputeconstant}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputemode}},
\code{\link{mlr_pipeops_imputeoor}},
\code{\link{mlr_pipeops_imputesample}}
}
\concept{Imputation PipeOps}
\concept{PipeOps}
