% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpLearnerCV.R
\name{mlr_pipeops_learner_cv}
\alias{mlr_pipeops_learner_cv}
\alias{PipeOpLearnerCV}
\title{Wrap a Learner into a PipeOp with Cross-validated Predictions as Features}
\format{
\code{\link{R6Class}} object inheriting from \code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.
}
\description{
Wraps an \code{\link[mlr3:Learner]{mlr3::Learner}} into a \code{\link{PipeOp}}.

Returns cross-validated predictions during training as a \code{\link[mlr3:Task]{Task}} and stores a model of the
\code{\link[mlr3:Learner]{Learner}} trained on the whole data in \verb{$state}. This is used to create a similar
\code{\link[mlr3:Task]{Task}} during prediction.

The \code{\link[mlr3:Task]{Task}} gets features depending on the capsuled \code{\link[mlr3:Learner]{Learner}}'s
\verb{$predict_type}. If the \code{\link[mlr3:Learner]{Learner}}'s \verb{$predict.type} is \code{"response"}, a feature \verb{<ID>.response} is created,
for \verb{$predict.type} \code{"prob"} the \verb{<ID>.prob.<CLASS>} features are created, and for \verb{$predict.type} \code{"se"} the new columns
are \verb{<ID>.response} and \verb{<ID>.se}. \verb{<ID>} denotes the \verb{$id} of the \code{\link{PipeOpLearnerCV}} object.

Inherits the \verb{$param_set} (and therefore \verb{$param_set$values}) from the \code{\link[mlr3:Learner]{Learner}} it is constructed from.

\code{\link{PipeOpLearnerCV}} can be used to create "stacking" or "super learning" \code{\link{Graph}}s that use the output of one \code{\link[mlr3:Learner]{Learner}}
as feature for another \code{\link[mlr3:Learner]{Learner}}. Because the \code{\link{PipeOpLearnerCV}} erases the original input features, it is often
useful to use \code{\link{PipeOpFeatureUnion}} to bind the prediction \code{\link[mlr3:Task]{Task}} to the original input \code{\link[mlr3:Task]{Task}}.
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpLearnerCV$new(learner, id = NULL, param_vals = list())
}\if{html}{\out{</div>}}
\itemize{
\item \code{learner} :: \code{\link[mlr3:Learner]{Learner}} \cr
\code{\link[mlr3:Learner]{Learner}} to use for cross validation / prediction, or a string identifying a
\code{\link[mlr3:Learner]{Learner}} in the \code{\link[mlr3:mlr_learners]{mlr3::mlr_learners}} \code{\link[mlr3misc:Dictionary]{Dictionary}}.
This argument is always cloned; to access the \code{\link[mlr3:Learner]{Learner}} inside \code{PipeOpLearnerCV} by-reference, use \verb{$learner}.\cr
\item \code{id} :: \code{character(1)}
Identifier of the resulting object, internally defaulting to the \code{id} of the \code{\link[mlr3:Learner]{Learner}} being wrapped.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

\code{\link{PipeOpLearnerCV}} has one input channel named \code{"input"}, taking a \code{\link[mlr3:Task]{Task}} specific to the \code{\link[mlr3:Learner]{Learner}}
type given to \code{learner} during construction; both during training and prediction.

\code{\link{PipeOpLearnerCV}} has one output channel named \code{"output"}, producing a \code{\link[mlr3:Task]{Task}} specific to the \code{\link[mlr3:Learner]{Learner}}
type given to \code{learner} during construction; both during training and prediction.

The output is a task with the same target as the input task, with features replaced by predictions made by the \code{\link[mlr3:Learner]{Learner}}.
During training, this prediction is the out-of-sample prediction made by \code{\link[mlr3:resample]{resample}}, during prediction, this is the
ordinary prediction made on the data by a \code{\link[mlr3:Learner]{Learner}} trained on the training phase data.
}

\section{State}{

The \verb{$state} is set to the \verb{$state} slot of the \code{\link[mlr3:Learner]{Learner}} object, together with the \verb{$state} elements inherited from the
\code{\link{PipeOpTaskPreproc}}. It is a named \code{list} with the inherited members, as well as:
\itemize{
\item \code{model} :: \code{any}\cr
Model created by the \code{\link[mlr3:Learner]{Learner}}'s \verb{$.train()} function.
\item \code{train_log} :: \code{\link{data.table}} with columns \code{class} (\code{character}), \code{msg} (\code{character})\cr
Errors logged during training.
\item \code{train_time} :: \code{numeric(1)}\cr
Training time, in seconds.
\item \code{predict_log} :: \code{NULL} | \code{\link{data.table}} with columns \code{class} (\code{character}), \code{msg} (\code{character})\cr
Errors logged during prediction.
\item \code{predict_time} :: \code{NULL} | \code{numeric(1)}
Prediction time, in seconds.
}
}

\section{Parameters}{

The parameters are the parameters inherited from the \code{\link{PipeOpTaskPreproc}}, as well as the parameters of the \code{\link[mlr3:Learner]{Learner}} wrapped by this object.
Besides that, parameters introduced are:
\itemize{
\item \code{resampling.method} :: \code{character(1)}\cr
Which resampling method do we want to use. Currently only supports \code{"cv"} and \code{"insample"}. \code{"insample"} generates
predictions with the model trained on all training data.
\item \code{resampling.folds} :: \code{numeric(1)}\cr
Number of cross validation folds. Initialized to 3. Only used for \code{resampling.method = "cv"}.
\item \code{keep_response} :: \code{logical(1)}\cr
Only effective during \code{"prob"} prediction: Whether to keep response values, if available. Initialized to \code{FALSE}.
}
}

\section{Internals}{

The \verb{$state} is currently not updated by prediction, so the \verb{$state$predict_log} and \verb{$state$predict_time} will always be \code{NULL}.
}

\section{Fields}{

Fields inherited from \code{\link{PipeOp}}, as well as:
\itemize{
\item \code{learner} :: \code{\link[mlr3:Learner]{Learner}}\cr
\code{\link[mlr3:Learner]{Learner}} that is being wrapped. Read-only.
\item \code{learner_model} :: \code{\link[mlr3:Learner]{Learner}}\cr
\code{\link[mlr3:Learner]{Learner}} that is being wrapped. This learner contains the model if the \code{PipeOp} is trained. Read-only.
}
}

\section{Methods}{

Methods inherited from \code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.
}

\examples{
library("mlr3")

task = tsk("iris")
learner = lrn("classif.rpart")

lrncv_po = po("learner_cv", learner)
lrncv_po$learner$predict_type = "response"

nop = mlr_pipeops$get("nop")

graph = gunion(list(
  lrncv_po,
  nop
)) \%>>\% po("featureunion")

graph$train(task)

graph$pipeops$classif.rpart$learner$predict_type = "prob"

graph$train(task)
}
\seealso{
https://mlr3book.mlr-org.com/list-pipeops.html

Other Meta PipeOps: 
\code{\link{mlr_pipeops_learner}}
}
\concept{Meta PipeOps}
\concept{Pipeops}
