% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TerminatorEvals.R
\name{TerminatorEvals}
\alias{TerminatorEvals}
\alias{mlr_terminators_evals}
\title{Terminator that stops after a number of evaluations}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link{Terminator}.}
\description{
Class to terminate the tuning depending on the number of evaluations.
An evaluation is defined by one resampling of a parameter value.
}
\section{Construction}{
\preformatted{TerminatorEvals$new()
term("evals")
}
}

\section{Parameters}{

\itemize{
\item \code{n_evals} :: \code{integer(1)}\cr
Number of allowed evaluations, default is 100L
}
}

\examples{
TerminatorEvals$new()
term("evals", n_evals = 5)
}
\seealso{
Other Terminator: 
\code{\link{TerminatorClockTime}},
\code{\link{TerminatorCombo}},
\code{\link{TerminatorModelTime}},
\code{\link{TerminatorNone}},
\code{\link{TerminatorPerfReached}},
\code{\link{TerminatorStagnation}},
\code{\link{Terminator}},
\code{\link{mlr_terminators}}
}
\concept{Terminator}
