% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tuner.R
\name{Tuner}
\alias{Tuner}
\title{Class for Tuning Algorithms}
\description{
The \link{Tuner} implements the optimization algorithm.
}
\details{
\link{Tuner} is a abstract base class that implements the base functionality each tuner must provide.
A subclass is implemented in the following way:
\itemize{
\item Inherit from Tuner.
\item Specify the private abstract method \verb{$.optimize()} and use it to call into your optimizer.
\item You need to call \code{instance$eval_batch()} to evaluate design points.
\item The batch evaluation is requested at the \link{TuningInstanceSingleCrit}/\link{TuningInstanceMultiCrit} object \code{instance}, so each batch is possibly executed in parallel via \code{\link[mlr3:benchmark]{mlr3::benchmark()}}, and all evaluations are stored inside of \code{instance$archive}.
\item Before the batch evaluation, the \link[bbotk:Terminator]{bbotk::Terminator} is checked, and if it is positive, an exception of class \code{"terminated_error"} is generated.
In the  later case the current batch of evaluations is still stored in \code{instance}, but the numeric scores are not sent back to the handling optimizer as it has lost execution control.
\item After such an exception was caught we select the best configuration from \code{instance$archive} and return it.
\item Note that therefore more points than specified by the \link[bbotk:Terminator]{bbotk::Terminator} may be evaluated, as the Terminator is only checked before a batch evaluation, and not in-between evaluation in a batch.
How many more depends on the setting of the batch size.
\item Overwrite the private super-method \code{.assign_result()} if you want to decide yourself how to estimate the final configuration in the instance and its estimated performance.
The default behavior is: We pick the best resample-experiment, regarding the given measure, then assign its configuration and aggregated performance to the instance.
}
}
\section{Private Methods}{

\itemize{
\item \code{.optimize(instance)} -> \code{NULL}\cr
Abstract base method. Implement to specify tuning of your subclass.
See details sections.
\item \code{.assign_result(instance)} -> \code{NULL}\cr
Abstract base method. Implement to specify how the final configuration is selected.
See details sections.
}
}

\section{Resources}{

\itemize{
\item \href{https://mlr3book.mlr-org.com/optimization.html#sec-tuner}{book section} on tuners.
\item \href{https://mlr3hyperband.mlr-org.com/}{mlr3hyperband} extension package for the Hyperband algorithm.
}
}

\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the object.
Used in tables, plot and text output.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{param_set}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Set of control parameters.}

\item{\code{param_classes}}{(\code{character()})\cr
Supported parameter classes for learner hyperparameters that the tuner can optimize.
Subclasses of \link[paradox:Param]{paradox::Param}.}

\item{\code{properties}}{(\code{character()})\cr
Set of properties of the tuner.
Must be a subset of \code{\link[mlr3:mlr_reflections]{mlr_reflections$tuner_properties}}.}

\item{\code{packages}}{(\code{character()})\cr
Set of required packages.
Note that these packages will be loaded via \code{\link[=requireNamespace]{requireNamespace()}}, and are not attached.}

\item{\code{label}}{(\code{character(1)})\cr
Label for this object.
Can be used in tables, plot and text output instead of the ID.}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Tuner-new}{\code{Tuner$new()}}
\item \href{#method-Tuner-format}{\code{Tuner$format()}}
\item \href{#method-Tuner-print}{\code{Tuner$print()}}
\item \href{#method-Tuner-help}{\code{Tuner$help()}}
\item \href{#method-Tuner-optimize}{\code{Tuner$optimize()}}
\item \href{#method-Tuner-clone}{\code{Tuner$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tuner-new"></a>}}
\if{latex}{\out{\hypertarget{method-Tuner-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tuner$new(
  id = "tuner",
  param_set,
  param_classes,
  properties,
  packages = character(),
  label = NA_character_,
  man = NA_character_
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier for the new instance.}

\item{\code{param_set}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Set of control parameters.}

\item{\code{param_classes}}{(\code{character()})\cr
Supported parameter classes for learner hyperparameters that the tuner can optimize.
Subclasses of \link[paradox:Param]{paradox::Param}.}

\item{\code{properties}}{(\code{character()})\cr
Set of properties of the tuner.
Must be a subset of \code{\link[mlr3:mlr_reflections]{mlr_reflections$tuner_properties}}.}

\item{\code{packages}}{(\code{character()})\cr
Set of required packages.
Note that these packages will be loaded via \code{\link[=requireNamespace]{requireNamespace()}}, and are not attached.}

\item{\code{label}}{(\code{character(1)})\cr
Label for this object.
Can be used in tables, plot and text output instead of the ID.}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tuner-format"></a>}}
\if{latex}{\out{\hypertarget{method-Tuner-format}{}}}
\subsection{Method \code{format()}}{
Helper for print outputs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tuner$format(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(\code{character()}).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tuner-print"></a>}}
\if{latex}{\out{\hypertarget{method-Tuner-print}{}}}
\subsection{Method \code{print()}}{
Print method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tuner$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\code{character()}).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tuner-help"></a>}}
\if{latex}{\out{\hypertarget{method-Tuner-help}{}}}
\subsection{Method \code{help()}}{
Opens the corresponding help page referenced by field \verb{$man}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tuner$help()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tuner-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-Tuner-optimize}{}}}
\subsection{Method \code{optimize()}}{
Performs the tuning on a \link{TuningInstanceSingleCrit} or \link{TuningInstanceMultiCrit} until termination.
The single evaluations will be written into the \link{ArchiveTuning} that resides in the \link{TuningInstanceSingleCrit}/\link{TuningInstanceMultiCrit}.
The result will be written into the instance object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tuner$optimize(inst)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inst}}{(\link{TuningInstanceSingleCrit} | \link{TuningInstanceMultiCrit}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tuner-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Tuner-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tuner$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
