## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
options(rmarkdown.html_vignette.check_title = FALSE)

## ----setup--------------------------------------------------------------------
library(mlts)

## -----------------------------------------------------------------------------
ar1_model <- mlts_model(q = 1)

## -----------------------------------------------------------------------------
ar1_model

## ----eval=FALSE---------------------------------------------------------------
#  mlts_model_formula(ar1_model)

## ----eval=FALSE---------------------------------------------------------------
#  mlts_model_paths(ar1_model)

## ----echo=FALSE, out.width="75%", fig.align='center'--------------------------
knitr::include_graphics(c("../vignettes/pathmodel_ar1.png"))

## ----echo=FALSE---------------------------------------------------------------
load("../data/ar1_data.rda")

## -----------------------------------------------------------------------------
head(ar1_data)

## ----eval=FALSE---------------------------------------------------------------
#  ar1_fit <- mlts_fit(
#    model = ar1_model,
#    data = ar1_data,
#    id = "ID",
#    ts = "Y1",
#    iter = 4000
#  )

## ----echo=FALSE---------------------------------------------------------------
ar1_fit <- readRDS("../vignettes/ar1_fit.rds")

## -----------------------------------------------------------------------------
summary(ar1_fit)

