% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catplotmlx.R
\name{catplotmlx}
\alias{catplotmlx}
\title{Plot Categorical Longitudinal Data}
\usage{
catplotmlx(r, col = NULL, breaks = NULL, plot = TRUE,
  color = "#194280", group = NULL, facet = TRUE, labels = NULL)
}
\arguments{
\item{r}{a data frame with a column \samp{id}, a column \samp{time}, 
a column with values and possibly Hk[ja column \samp{group}.}

\item{col}{a vector of 3 column numbers: (\samp{id}, \samp{time/x}, \samp{y}. Default = c(1, 2,3).}

\item{breaks}{one of:
\itemize{
  \item a vector giving the breakpoints,
  \item a single number giving the number of segments.
}}

\item{plot}{if \code{TRUE} the empirical distribution is displayed, if \code{FALSE}
the values are returned}

\item{color}{a color to be used for the plots (default="#194280")}

\item{group}{variable to be used for defining groups (by default, \samp{group} is used when it exists)}

\item{facet}{makes subplots for different groups if \code{TRUE}}

\item{labels}{vector of strings}
}
\value{
a ggplot object if \code{plot=TRUE} ; otherwise, a list with fields:
\itemize{
  \item color a vector of colors used for the plot 
  \item y a data frame with the values of the empirical distribution computed at each time point
}
}
\description{
Plot the empirical distribution of categorical longitudinal data.
}
\details{
See http://simulx.webpopix.org/mlxr/catplotmlx/ for more details.
}
\examples{
\dontrun{
  catModel <- inlineModel("
  [LONGITUDINAL]
  input =  {a,b}
  EQUATION:
  lp1=a-b*t
  lp2=a-b*t/2
  DEFINITION:
  y = {type=categorical, categories={1,2,3}, 
  logit(P(y<=1))=lp1, logit(P(y<=2))=lp2}
  ")
  
  y.out  <- list(name='y', time=seq(0, 100, by=4))

  Ng  <- 1000
  g1 <- list(size=Ng, parameter=c(a=6,b=0.2))
  res <- simulx(model=catModel, output=y.out, group=g1)
  catplotmlx(res$y)
  catplotmlx(res$y, breaks=seq(-2,102,by=8), color="purple") 
  catplotmlx(res$y, breaks=5, color="#490917") 
  
  g2 <- list(size=Ng, parameter=c(a=10,b=0.2))
  res <- simulx(model=catModel, output=y.out, group=list(g1,g2))
  catplotmlx(res$y) 
  catplotmlx(res$y, group="none")
  
  g3 <- list(size=Ng, parameter=c(a=6,b=0.4))
  g4 <- list(size=Ng, parameter=c(a=10,b=0.4))
  res <- simulx(model=catModel, output=y.out, group=list(g1,g2,g3,g4))
  catplotmlx(res$y)
   
  cov <- data.frame(id=levels(res$y$id), a=rep(c(6,10,6,10),each=Ng), 
                    b=rep(c(0.2,0.2,0.4,0.4),each=Ng))
  catplotmlx(res$y, group=cov) 
}
}
