% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpopmlx.R
\name{simpopmlx}
\alias{simpopmlx}
\title{Population parameters simulation}
\usage{
simpopmlx(
  n = 1,
  project = NULL,
  fim = "needed",
  parameter = NULL,
  corr = NULL,
  kw.max = 100
)
}
\arguments{
\item{n}{the number of vectors of population parameters (default = 1),}

\item{project}{a Monolix project, assuming that the Fisher information Matrix was estimated by Monolix.}

\item{fim}{the Fisher Information Matrix estimated by Monolix. fim={"sa", "lin"} (default="sa")}

\item{parameter}{a data frame with a column \samp{pop.param} (no default), a column \samp{sd} (no default), 
possibly a column \samp{trans} (default ='N') and possibly columns \samp{lim.a} (default=0) and
\samp{lim.b} (default=1). Only when project is not used.}

\item{corr}{correlation matrix of the population parameters (default = identity). Only when project is not used.}

\item{kw.max}{maximum number of trials for generating a positive definite covariance matrix (default = 100)}
}
\description{
Draw population parameters using the covariance matrix of the estimates.
}
\details{
See http://simulx.webpopix.org/mlxr/simpopmlx/ for more details.
}
\examples{
\dontrun{
project.file <- 'monolixRuns/theophylline1_project.mlxtran'  #relative path
pop1 <- simpopmlx(n=3, project=project.file)
}
}
