% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpreters.R
\name{rm_interpreter}
\alias{rm_interpreter}
\title{Interpret Results of Restricted Means Analysis}
\usage{
rm_interpreter(rm_res)
}
\arguments{
\item{rm_res}{An object of class 'restriktor', typically the result of a call
to \code{\link[restriktor]{restriktor}}.}
}
\value{
A character string with an interpretation of the analysis
results, including the R-squared values, their reduction, and the Generalized
Order-Restricted Information Criterion (GORIC) if available.
}
\description{
This function provides a human-readable interpretation of the results of a
restricted means analysis. It compares the original (unconstrained) and
reduced (restricted) R-squared values to evaluate the imposed constraints. It
also returns the Generalized Order-Restricted Information Criterion (GORIC)
which can be used for model comparison.
}
\examples{
model <- mmir_model(mpg ~ -1 + hp + wt, data = mtcars, engine = "lm",
                    standardize = TRUE)
rm_res <- restriktor::restriktor(model, constraints = 'hp < wt')
rm_interpreter(rm_res) |> cat()

}
\references{
Vanbrabant, L., & Rosseel, Y. (2020). An Introduction to Restriktor: Evaluating informative hypotheses for linear models. In Small Sample Size Solutions (1st ed., p. 16). Routledge. \url{https://www.taylorfrancis.com/chapters/oa-edit/10.4324/9780429273872-14/introduction-restriktor-leonard-vanbrabant-yves-rosseel}
}
\seealso{
\code{\link[restriktor]{restriktor}} for generating 'restriktor' objects.
}
