% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_funcs.R
\name{d_eq_spaced}
\alias{d_eq_spaced}
\title{Calculate Equally Spaced Differences}
\usage{
d_eq_spaced(k, f)
}
\arguments{
\item{k}{An integer representing the number of groups (k = 3, ..., 8).}

\item{f}{A numeric value representing the effect size (f = 0.10, 0.15, 0.20,
0.25, 0.30, 0.40). Typical values represent small (0.10), medium (0.25), and
large (0.40) effects.}
}
\value{
A numeric value representing the equally spaced difference, d, based
on the number of groups (k) and the effect size (f).
}
\description{
This function calculates the equally spaced differences between means in a
one-way ANOVA setup. It is based on the formula presented in Vanbrabant et al.
(2015) for calculating differences between means, d.
}
\examples{
d_eq_spaced(4, 0.25) # For k = 4 and f = 0.25
}
\references{
Vanbrabant, Leonard; Van De Schoot, Rens; Rosseel, Yves (2015). Constrained
statistical inference: sample-size tables for ANOVA and regression. Frontiers
in Psychology, 5. DOI:10.3389/fpsyg.2014.01565.
URL: https://www.frontiersin.org/articles/10.3389/fpsyg.2014.01565
}
