% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{refit_multiple_optimizers}
\alias{refit_multiple_optimizers}
\title{Refitting MMRM with Multiple Optimizers}
\usage{
refit_multiple_optimizers(
  fit,
  n_cores = 1L,
  optimizers = c("L-BFGS-B", "BFGS", "CG", "nlminb"),
  accept_singular = TRUE
)
}
\arguments{
\item{fit}{(\code{mmrm_fit})\cr original model fit from \code{\link[=fit_single_optimizer]{fit_single_optimizer()}}.}

\item{n_cores}{(\code{count})\cr number of cores which could in principle be used for
parallel computations on Linux or Mac machines.}

\item{optimizers}{(\code{character})\cr all possible optimizers to be used for fitting.}

\item{accept_singular}{(\code{flag})\cr whether singular design matrices are reduced
to full rank automatically and additional coefficient estimates will be missing.}
}
\value{
The best (in terms of log likelihood) fit which converged.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\note{
For Windows, no parallel computations are currently implemented.
}
\examples{
fit <- fit_single_optimizer(
  formula = FEV1 ~ RACE + SEX + ARMCD * AVISIT + us(AVISIT | USUBJID),
  data = fev_data,
  weights = rep(1, nrow(fev_data)),
  optimizer = "nlminb"
)
best_fit <- refit_multiple_optimizers(fit)
}
