% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing.R
\name{df_md}
\alias{df_md}
\title{Calculation of Degrees of Freedom for Multi-Dimensional Contrast}
\usage{
df_md(object, contrast)
}
\arguments{
\item{object}{(\code{mmrm})\cr the MMRM fit.}

\item{contrast}{(\code{matrix})\cr numeric contrast matrix, if given a \code{numeric}
then this is coerced to a row vector. Note that this should not include
elements for singular coefficient estimates, i.e. only refer to the
actually estimated coefficients.}
}
\value{
List with \code{num_df}, \code{denom_df}, \code{f_stat} and \code{p_val} (2-sided p-value).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Calculates the estimate, standard error, degree of freedom,
t statistic and p-value for one-dimensional contrast, depending on the method
used in \code{\link[=mmrm]{mmrm()}}.
}
\examples{
object <- mmrm(
  formula = FEV1 ~ RACE + SEX + ARMCD * AVISIT + us(AVISIT | USUBJID),
  data = fev_data
)
contrast <- matrix(data = 0, nrow = 2, ncol = length(object$beta_est))
contrast[1, 2] <- contrast[2, 3] <- 1
df_md(object, contrast)
}
