% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jt_kde.R
\name{JT.KDE.ap}
\alias{JT.KDE.ap}
\title{Fit bivariate joint tail model with Kernel density estimator (Adapted from Cooley et al., 2019)}
\usage{
JT.KDE.ap(
  u2,
  pbas,
  pobj,
  beta,
  vtau,
  devplot = F,
  kk,
  mar1,
  mar2,
  px,
  py,
  interh = NA
)
}
\arguments{
\item{u2}{Two column data frame}

\item{pbas}{joint return period to be modelled with a kde}

\item{pobj}{objective joint return period modelled with the joint tail model}

\item{beta}{smoothing parameter for the transition between asymptotic dependent and independent regimes near the axes}

\item{vtau}{estimate of the rank correlation between the two variables}

\item{devplot}{additional plots for development (significantly slows the function)}

\item{kk}{uniform margins of the original data}

\item{mar1}{Values of the first margin}

\item{mar2}{Values of the second margin}

\item{px}{Uniform values of the first margin with a mixed distribution (empirical below and gpd above a threshold)}

\item{py}{Uniform values of the second margin with a mixed distribution (empirical below and gpd above a threshold)}

\item{interh}{type of hazard interrelation '\code{comb}' for compound and '\code{casc}' for cascade,}
}
\value{
a list containing the following:
\itemize{
\item levelcurve - data frame the objective containing level curve with a return level '\code{pobj}'
\item wq0ri - matrix of the base level curve with a return level '\code{pbas}'
\item etaJT - threshold dependent extremal dependence measure
\item chiJT - threshold dependent coefficient of tail dependence
}
}
\description{
Fit bivariate joint tail model with Kernel density estimator (Adapted from Cooley et al., 2019)
}
\examples{
  \dontrun{
jtres<-JT.KDE.ap(u2=u2,pbas=0.01,pobj=upobj,beta=100,kk=kk,vtau=vtau,
devplot=FALSE,mar1=uu[,1],mar2=uu[,2],px=pp[,1],py=pp[,2],interh=interh)
plot(jtres$levelcurve)
}
}
\references{
Tilloy, A., Malamud, B.D., Winter, H. and Joly-Laugel, A., 2020.
Evaluating the efficacy of bivariate extreme modelling approaches
for multi-hazard scenarios. Natural Hazards and Earth System Sciences, 20(8), pp.2091-2117.

Cooley, D., Thibaud, E., Castillo, F. and Wehner, M.F., 2019.
A nonparametric method for producing isolines of bivariate exceedance probabilities.
Extremes, 22(3), pp.373-390.
}
\seealso{
\code{\link[texmex]{chi}}
}
