% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvmf.R
\name{cvmf}
\alias{cvmf}
\title{Cross-Validated Median Fit (CVMF) Test}
\usage{
cvmf(formula, data, method = c("exact", "approximate", "efron",
  "breslow"), trunc = 0.95, subset, na.action, f.weight = c("linear",
  "quadratic", "exponential"), weights, singular.ok = TRUE)
}
\arguments{
\item{formula}{A formula object, with the response on the left of a ~
operator, and the terms on the right. The response must be a survival
object as returned by the Surv() function from the survival package.}

\item{data}{A data frame, list or environment (or object coercible by
as.data.frame to a data frame) containing the variables in the model
or in the subset and the weights argument.}

\item{method}{A character string specifying the method for tie handling in coxph().
If there are no tied death times all the methods are equivalent.
Following the coxph() function in the survival package, the Efron
approximation is used as the default. The survival package justifies this
due to the Efron method being is more accurate when dealing with tied death
times, and is as efficient computationally than the common Breslow method.
The "exact partial likelihood" is equivalent to a 'conditional logistic model,
and is appropriate when the times are a small set of discrete values.
This argument does not exist in the coxr() function in the coxrobust package.
For coxr(), method is based on a smooth modification of the partial likelihood.
See documentation from survival package for more on coxph() method and
coxrobust package for coxr() method.}

\item{trunc}{A value that determines the trimming level for the robust
estimator. The default is 0.95. Roughtly, quantile of the sample
\eqn{T_i exp(\beta'Z_i)}. It is an argument in the coxr() function
in the coxrobust package.}

\item{subset}{Expression indicating which subset of the rows of data should be
used in the fit. All observations are included by default.}

\item{na.action}{A missing-data filter function, applied to the model.frame,
after any subset argument has been used.}

\item{f.weight}{A type of weighting function for coxr() in the coxrobust package.
The default is \code{quadratic}. See coxr() documentation for more.}

\item{weights}{A vector of case weights for coxph() in the survival package.
See coxph() documentation for more.}

\item{singular.ok}{Logical value indicating how to handle collinearity in the
model matrix. If \code{TRUE}, the program will automatically skip over columns
of the X matrix that are linear combinations of earlier columns. In this case
the coefficients for such columns will be NA, and the variance matrix will contain
zeros. For ancillary calculations, such as the linear predictor, the missing
coefficients are treated as zeros.}
}
\value{
An object of class \code{cvmf} computed by the cross-validated median fit test
(CVMF) to test between the PLM and IRR methods of estimating the Cox model.
See \code{cvmf_object} for more details.
}
\description{
Applies cross-validated log-likelihood to test between
partial likelihood maximization (PLM) and the iteratively reweighted
robust (IRR) method of estimation for a given application of the Cox model.
For more, see: Desmarais, B. A., & Harden, J. J. (2012). Comparing partial
likelihood and robust estimation methods for the Cox regression model.
Political Analysis, 20(1), 113-135.
}
\details{
This function implements the cross-validated median fit (CVMF) test.
The function cvmf() tests between the partial
likelihood maximization (PLM) and the iteratively reweighted robust
(IRR) method of estimation for a given application of the Cox model.
The Cox model is a partial parametric model that does not make assumptions
about the baseline hazard. It can be estimated via PLM, the standard
estimator, or IRR, a robust estimator that identifies and downweights
outliers. The choice between the two methods involves a trade-off
between bias and efficiency. PLM is more efficient, but biased under
specification problems. IRR reduces bias, but results in high
variance due to the loss of efficiency. The cvmf() function returns an
object to identify the prefered estimation method.

See also \code{\link{coxph}}, \code{\link{coxr}}, \code{\link{Surv}}
}
\examples{
\donttest{
  set.seed(12345)
  x1 <- rnorm(100)
  x2 <- rnorm(100)

  x2e <- x2 + rnorm(100, 0, 0.5)

  y <- rexp(100, exp(x1 + x2))
  y <- survival::Surv(y)

  dat <- data.frame(y, x1, x2e)
  form <- y ~ x1 + x2e

  results <- cvmf(formula = form, data = dat)
  }
}
