# Author : Paul Poncet

# The following R code computes the density function, distribution function,
# and quantiles of the random variable
#          Z =  argmax_t (B(t) - t^2)
# where B(t) is two-sided Brownian motion starting from zero.
# It relies on C code due to Groeneboom and Wellner (2001).


.N <- 10 + 1

#comput_coeffs <-
#function()
#{
#
#  A <- rep(0, .N)
#  B <- rep(0, .N)
#  .C("ComputeCoefficients",
#     a = as.double(A),
#     b = as.double(B),
#     PACKAGE = "modeest")
#}

.coeffs_a_b <-
function(N)
{
  a <- 1
  b <- c(0, 2/3)
  cc <- 1

  for (n in 1:N) {
    cc <- -(2*n-3)*(2*n+1)*cc/(16*n^2*(2*n-1))

    sum1 <- 0
    sum2 <- 0

		for (k in 0:(n-1)) {
      sum2 <- sum2 + a[n-k]*beta(3*n-2*k-2,k+1.5)/(gamma(k+1)*((-2)^(k+1)))
		}
		if (n > 1) b[n+1] <- sum2

		for (k in 0:(n-1)) {
      sum1 <- sum1 + b[n-k+1]*beta(3*n-2*k-0.5,k+1.5)/(pi*gamma(k+1)*(-2)^k)
		}

		a[n+1] <- cc - sum1
  }
  
  return(list(a = a, b = b))
}

.a <- .coeffs_a_b(.N-1)$a
.b <- .coeffs_a_b(.N-1)$b

.zai <- c(0, -2.33810741045977, -4.08794944413097, -5.52055982809608, -6.78670809007212,
-7.94413358712112, -9.02265085334119, -10.0401743415583, -11.0085243037333,
-11.9360155632363, -12.8287767528658, -13.6914890352107,
-14.5278299517754,
-15.340755135978 ,
-16.1326851569458,
-16.9056339974300,
-17.6613001056971,
-18.4011325992071,
-19.1263804742470,
-19.8381298917215,
-20.5373329076776,
-21.2248299436421,
-21.9013675955852,
-22.5676129174965,
-23.2241650011217,
-23.8715644555359,
-24.5103012365897,
-25.140821166149 ,
-25.7635314009828,
-26.3788050521373,
-26.9869851116064 ,
-27.5883878098825,
-28.1833055026327,
-28.7720091652375,
-29.3547505587663,
-29.9317641190866,
-30.5032686114186,
-31.0694685851838,
-31.6305556580127,
-32.1867096529521,
-32.7380996090003,
-33.2848846819015,
-33.8272149495087,
-34.3652321338637,
-34.8990702503454,
-35.4288561927480,
-35.9547102618987,
-36.4767466443749,
-36.9950738469946,
-37.5097950920051,
-38.0210086772553,
-38.5288083050943,
-39.0332833832726,
-39.5345193007231,
-40.0325976807543,
-40.5275966138898,
-41.0195908723326,
-41.5086521078053,
-41.9948490343265,
-42.4782475973085,
-42.9589111302167,
-43.4369004998970,
-43.9122742415638,
-44.3850886843395,
-44.8553980681459,
-45.3232546526705,
-45.7887088190574,
-46.2518091649126,
-46.7126025931566,
-47.1711343952064,
-47.6274483289275,
-48.0815866917533,
-48.5335903893369,
-48.9834990000647,
-49.4313508357369,
-49.8771829986895,
-50.3210314356123,
-50.7629309882944,
-51.2029154415106,
-51.641017568245 ,
-52.0772691724297,
-52.5117011293677,
-52.9443434239894,
-53.3752251870858,
-53.8043747296479,
-54.2318195754332,
-54.6575864918688,
-55.0817015193976,
-55.5041899993597,
-55.9250766005006,
-56.3443853441868,
-56.762139628406 ,
-57.1783622506243,
-57.5930754295642,
-58.0063008259684,
-58.4180595624046,
-58.8283722421662,
-59.2372589673193,
-59.6447393559427,
-60.0508325586043)[1:.N]


.vai <- c(0,
0.701210822720691 ,
-0.803111369654865,
0.865204025893943 ,
-0.910850737049487,
0.947335709441494 ,
-0.977922808569447,
1.00437012266027  ,
-1.02773868882076 ,
1.04872064858817  ,
-1.06779385915741 ,
1.08530283135068  ,
-1.10150457027748 ,
1.11659617793264  ,
-1.13073231049318 ,
1.14403667327354  ,
-1.15660984911656 ,
1.16853478448752  ,
-1.17988072987014 ,
1.19070613115877  ,
-1.20106079151982 ,
1.21098751486828  ,
-1.22052337389726 ,
1.22970070150968  ,
-1.23854787532963 ,
1.24708994525940  ,
-1.25534914047573 ,
1.26334528275080  ,
-1.2710961262186  ,
1.27861763882425  ,
-1.2859242371227  ,
1.29302898344995  ,
-1.29994375251105 ,
1.30667937293209  ,
-1.31324574818065 ,
1.31965196037751  ,
-1.32590635983844 ,
1.3320166426477   ,
-1.33798991814229 ,
1.34383276784898  ,
-1.34955129714744 ,
1.35515118071591  ,
-1.36063770264053 ,
1.36601579192678  ,
-1.37129005403424 ,
1.37646479896008  ,
-1.38154406631710 ,
1.38653164778595  ,
-1.39143110726647 ,
1.39624579900672  ,
-1.40097888394977 ,
1.40563334450532  ,
-1.41021199792600 ,
1.41471750844411  ,
-1.41915239830507 ,
1.42351905781619  ,
-1.42781975451505 ,
1.43205664154883  ,
-1.43623176534515 ,
1.44034707264545  ,
-1.44440441696387 ,
1.44840556452710  ,
-1.452352199745   ,
1.45624593025574  ,
-1.46008829158498 ,
1.46388075145402  ,
-1.46762471376848 ,
1.47132152231547  ,
-1.47497246419485 ,
1.47857877300712  ,
-1.48214163181850 ,
1.48566217592181  ,
-1.48914149540985 ,
1.49258063757633  ,
-1.49598060915832 ,
1.49934237843243  ,
-1.50266687717632 ,
1.50595500250562  ,
-1.50920761859589 ,
1.51242555829801  ,
-1.51560962465502 ,
1.5187605923275   ,
-1.52187920893398 ,
1.52496619631260  ,
-1.52802225170944 ,
1.53104804889851  ,
-1.5340442392383  ,
1.53701145266898  ,
-1.53995029865436 ,
1.54286136707213  ,
-1.54574522905597 ,
1.54860243779237  ,
-1.55143352927535 ,
1.55423902302145  ,
-1.55701942274780 ,
1.55977521701519  ,
-1.56250687983868 ,
1.56521487126733  ,
-1.56789963793525 ,
1.57056161358544)[1:.N]


.airyz <-
function()
{

  Z <- rep(0, .N)
  V <- rep(0, .N)
  .C("airyzeros_R",
     zai = as.double(Z),
     vai = as.double(V),
     PACKAGE = "modeest")
}


dchern <-
function(x,
         log = FALSE)
{
###########################
# Chernoff density function
###########################

  p <- sapply(x, FUN = function(xx) .C("f_Z_R",
                                       x = as.double(xx),
                                       s = double(1),
                                       a = as.double(.a),
                                       b = as.double(.b),
                                       zai = as.double(.zai),
                                       vai = as.double(.vai),
                                       PACKAGE = "modeest")$s)
       
  if (log) return(log(p))
  else return(p)
}


pchern <-
function(q,
         lower.tail = TRUE,
         log.p = FALSE)
{
################################
# Chernoff distribution function
################################

  p <- sapply(q, FUN = function(qq) .C("F_Z_R",
                                       x = as.double(qq),
                                       s = double(1),
                                       a = as.double(.a),
                                       b = as.double(.b),
                                       zai = as.double(.zai),
                                       vai = as.double(.vai),
                                       PACKAGE = "modeest")$s)

  if (lower.tail & log.p) return(log(p))
  if (lower.tail & !log.p) return(p)
  if (!lower.tail & log.p) return(log(1-p))
  if (!lower.tail & !log.p) return(1-p)
  
  return(p)
}


qchern <-
function(p,
         lower.tail = TRUE,
         log.p = FALSE)
{
############################
# Chernoff quantile function
############################

  if (p < 0 | p > 1) stop("argument 'p' must belong to [0, 1]")
  if (lower.tail & log.p) p <- exp(p)
  else if (!lower.tail & log.p) p <- 1 - exp(p)
  else if (!lower.tail & !log.p) p <- 1-p

  q <- sapply(p, FUN = function(pp) .C("quantile_function_R",
                                       u = as.double(pp),
                                       s = double(1),
                                       a = as.double(.a),
                                       b = as.double(.b),
                                       zai = as.double(.zai),
                                       vai = as.double(.vai),
                                       PACKAGE = "modeest")$s)
  
  return(q)
}


rchern <-
function(n)
{
#################################################
# Random generation for the Chernoff distribution
#################################################

  p <- runif(n)
  return(qchern(p))
}

