% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmforest.R
\name{pmforest}
\alias{pmforest}
\alias{gettree.pmforest}
\title{Compute model-based forest from model.}
\usage{
pmforest(model, data = NULL, zformula = ~., ntree = 500L,
  perturb = list(replace = FALSE, fraction = 0.632), mtry = NULL,
  applyfun = NULL, cores = NULL, control = ctree_control(teststat =
  "quad", testtype = "Univ", mincriterion = 0, saveinfo = FALSE, lookahead =
  TRUE, ...), trace = FALSE, ...)

\method{gettree}{pmforest}(object, tree = 1L, saveinfo = TRUE,
  coeffun = coef, ...)
}
\arguments{
\item{model}{a model object.}

\item{data}{data. If \code{NULL} the data from the model object are used.}

\item{zformula}{formula describing which variable should be used for partitioning.
Default is to use all variables in data that are not in the model (i.e. \code{~ .}).}

\item{ntree}{number of trees.}

\item{perturb}{a list with arguments replace and fraction determining which type of 
resampling with \code{replace = TRUE} referring to the n-out-of-n bootstrap and 
\code{replace = FALSE} to sample splitting. fraction is the number of observations 
to draw without replacement.}

\item{mtry}{number of input variables randomly sampled as candidates at each 
node (Default \code{NULL} corresponds to \code{ceiling(sqrt(nvar))}). 
Bagging, as special case of a random forest without random input variable 
sampling, can be performed by setting mtry either equal to Inf or 
equal to the number of input variables.}

\item{applyfun}{see \code{\link[partykit]{cforest}}.}

\item{cores}{see \code{\link[partykit]{cforest}}.}

\item{control}{control parameters, see \code{\link[partykit]{ctree_control}}.}

\item{trace}{a logical indicating if a progress bar shall be printed while 
the forest grows.}

\item{...}{additional parameters passed on to model fit such as weights.}

\item{object}{an object returned by pmforest.}

\item{tree}{an integer, the number of the tree to extract from the forest.}

\item{saveinfo}{logical. Should the model info be stored in terminal nodes?}

\item{coeffun}{function that takes the model object and returns the coefficients. 
Useful when coef() does not return all coefficients (e.g. survreg).}
}
\value{
cforest object
}
\description{
Input a parametric model and get a forest.
}
\seealso{
\code{\link[partykit]{gettree}}
}
