% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numbers_math.R
\name{ldmvnorm}
\alias{ldmvnorm}
\title{Multivariante Normal: log-density}
\usage{
ldmvnorm(y, mu, E)
}
\arguments{
\item{y}{observations, numeric or reference object of class 'number'}

\item{mu}{mean vector, numeric of reference object of class 'number'}

\item{E}{covariance matrix, numeric of reference object of class 'number'}
}
\value{
Returns a 'numeric' or a reference object of class 'number'
}
\description{
Considering a Multivariate Normal Distribution calculates the log-density
\deqn{ld = -0.5 * (n * log(2 * \pi) * log(|\Sigma|) + y^T \Sigma y)}
}
\examples{
modello.init()
y = number(rnorm(10))
mu = number(rep(0, 10))
E = number(diag(1, 10))
ld = ldmvnorm(y, mu, E)
print(ld)
print(ld$v)
modello.close()
}
\author{
Filippo Monari
}
