% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{module.RNN}
\alias{module.RNN}
\title{R6 class representing an RNN.}
\description{
R6 class representing an RNN.

R6 class representing an RNN.
}
\author{
Filippo Monari
}
\section{Super class}{
\code{\link[modello:module]{modello::module}} -> \code{module.RNN}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{module.RNN$new()}}
\item \href{#method-save}{\code{module.RNN$save()}}
\item \href{#method-op}{\code{module.RNN$op()}}
\item \href{#method-pars}{\code{module.RNN$pars()}}
\item \href{#method-rus}{\code{module.RNN$rus()}}
\item \href{#method-H}{\code{module.RNN$H()}}
\item \href{#method-fc}{\code{module.RNN$fc()}}
\item \href{#method-clone}{\code{module.RNN$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="module" data-id="j">}\href{../../modello/html/module.html#method-j}{\code{modello::module$j()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="module" data-id="name">}\href{../../modello/html/module.html#method-name}{\code{modello::module$name()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="module" data-id="npars">}\href{../../modello/html/module.html#method-npars}{\code{modello::module$npars()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="module" data-id="obj">}\href{../../modello/html/module.html#method-obj}{\code{modello::module$obj()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="module" data-id="y">}\href{../../modello/html/module.html#method-y}{\code{modello::module$y()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialisation method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module.RNN$new(tx, nh, nx, acth, ny, acty, par.h = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tx}}{transposition flag. If > 0 op(x) = t(x)}

\item{\code{nh}}{integer vector of length equal to the hidden layes indicating the number of
hidden units for each layer}

\item{\code{nx}}{integer, number if inputs}

\item{\code{acth}}{activation function for the recurrent units}

\item{\code{ny}}{integer, number of outputs of the last fully connected layer}

\item{\code{acty}}{activation function for the last fully connected layer}

\item{\code{par.h}}{logical, true => the initial hidden state is treated as a paramter of the optimisation}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-save"></a>}}
\if{latex}{\out{\hypertarget{method-save}{}}}
\subsection{Method \code{save()}}{
Save the module to an RDS file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module.RNN$save(of, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{of}}{output file name or path}

\item{\code{...}}{additional arguments to be passed to the function \code{base::saveRDS}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-op"></a>}}
\if{latex}{\out{\hypertarget{method-op}{}}}
\subsection{Method \code{op()}}{
Runs the calculation stored in the module
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module.RNN$op(X)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{'number', module inputs}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pars"></a>}}
\if{latex}{\out{\hypertarget{method-pars}{}}}
\subsection{Method \code{pars()}}{
Returns a list with the model parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module.RNN$pars()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rus"></a>}}
\if{latex}{\out{\hypertarget{method-rus}{}}}
\subsection{Method \code{rus()}}{
Returns a list with the recurrent units
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module.RNN$rus()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-H"></a>}}
\if{latex}{\out{\hypertarget{method-H}{}}}
\subsection{Method \code{H()}}{
Returns the initial hidden state
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module.RNN$H()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fc"></a>}}
\if{latex}{\out{\hypertarget{method-fc}{}}}
\subsection{Method \code{fc()}}{
Returns the final fully connected layer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module.RNN$fc()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module.RNN$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
