% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasummary_balance.R
\name{datasummary_balance}
\alias{datasummary_balance}
\title{Balance table: Summary statistics for different subsets of the data (e.g.,
control and treatment groups)}
\usage{
datasummary_balance(
  formula,
  data,
  output = "default",
  fmt = 1,
  title = NULL,
  notes = NULL,
  align = NULL,
  add_columns = NULL,
  add_rows = NULL,
  dinm = TRUE,
  dinm_statistic = "std.error",
  ...
)
}
\arguments{
\item{formula}{a one-sided formula with the "condition" or "column" variable
on the right-hand side.}

\item{data}{A data.frame (or tibble). If this data includes columns called
"blocks", "clusters", and/or "weights", the "estimatr" package will
consider them when calculating the difference in means.}

\item{output}{filename or object type (character string)
\itemize{
\item Supported filename extensions: .html, .tex, .md, .txt, .png, .jpg.
\item Supported object types: "default", "html", "markdown", "latex", "latex_tabular", "data.frame", "modelsummary_list", "gt", "kableExtra", "huxtable", "flextable".
\item To change the default output format, type \code{options(modelsummary_default = "latex")}, where \code{latex} can be any of the valid object types listed above.
\item Warning: the \code{output} argument \emph{cannot} be used when customizing tables with external packages.
\item See the 'Details' section below for more information.
}}

\item{fmt}{determines how to format numeric values
\itemize{
\item integer: the number of digits to keep after the period \code{format(round(x, fmt), nsmall=fmt)}
\item character: passed to the \code{sprintf} function (e.g., '\\%.3f' keeps 3 digits with trailing zero). See \code{?sprintf}
\item function: returns a formatted character string.
}}

\item{title}{string}

\item{notes}{list or vector of notes to append to the bottom of the table.}

\item{align}{A character string of length equal to the number of columns in
the table.  "lcr" means that the first column will be left-aligned, the 2nd
column center-aligned, and the 3rd column right-aligned.}

\item{add_columns}{a data.frame (or tibble) with the same number of rows as
your main table.}

\item{add_rows}{a data.frame (or tibble) with the same number of columns as
your main table. By default, rows are appended to the bottom of the table.
You can define a "position" attribute of integers to set the row positions.
See Examples section below.}

\item{dinm}{TRUE calculates a difference in means with uncertainty
estimates. This option is only available if the \code{estimatr} package is
installed. If \code{data} includes columns named "blocks", "clusters", or
"weights", this information will be taken into account automatically by
\code{estimatr::difference_in_means}.}

\item{dinm_statistic}{string: "std.error" or "p.value"}

\item{...}{all other arguments are passed through to the extractor and
table-making functions. This allows users to pass arguments directly to
\code{modelsummary} in order to affect the behavior of other functions behind
the scenes. Examples include:
\itemize{
\item \code{broom::tidy(exponentiate=TRUE)} to exponentiate logistic regression
\item \code{kableExtra::kbl(escape=FALSE)} to avoid escaping math characters in \code{kableExtra} tables.
\item \code{performance::model_performance(metrics="RMSE")} to select goodness-of-fit statistics to extract using the \code{performance} package (must have set \code{options(modelsummary_get="easystats")} first).
}}
}
\description{
Balance table: Summary statistics for different subsets of the data (e.g.,
control and treatment groups)
}
\examples{
\dontrun{
datasummary_balance(~am, mtcars)
}
}
