% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{suggest_gain}
\alias{suggest_gain}
\title{Plot Gain Chart and Lift Chart}
\usage{
suggest_gain(addTo, outChar, predTag = "pred_test", modelTag = NULL,
  cuts = 51, type = NULL)
}
\arguments{
\item{addTo}{Summary list that contains model fits to compare.}

\item{outChar}{A charactor value of output class name.}

\item{predTag}{Select prediction results that contains predTag on their name.}

\item{modelTag}{Select model fits that contains modelTag on their name.}

\item{cuts}{Integer indicating the number of splits of probability buckets.}

\item{type}{Plot different type of charts. "Gain" for gain chart.
"Lift" for lift chart. "PctAcc" for accumulated event percent. "Pct" for event
percent.}
}
\description{
\code{suggest_gain} Gain and Lift charts are widely used in marketing and related contexts.
They indicate the effectiveness of predictive models compared to the results obtained
without the predictive model.
}
\examples{
\dontrun{
library(mlbench)
data(PimaIndiansDiabetes)
index <- sample(seq_len(nrow(PimaIndiansDiabetes)), 500)
trainingSet <- PimaIndiansDiabetes[index, ]
testSet <- PimaIndiansDiabetes[-index, ]
x <- trainingSet[, -9]
y <- trainingSet[, 9]
x_test <- testSet[, -9]
y_test <- testSet[, 9]
sSummary <- list()
sSummary <- add_model(sSummary, x, y)
sSummary <- add_model(sSummary, x, y, model = c("C5.0Cost", "glmnet"), modelTag = "others")
sSummary <- add_prob(sSummary, x_test, y_test, outChar = "pos")

suggest_gain(sSummary, outChar = "pos")
suggest_gain(sSummary, outChar = "pos", modelTag = "glm|svm", type = "Lift")
suggest_gain(sSummary, outChar = "pos", modelTag = "glm|svm", type = "PctAcc")
suggest_gain(sSummary, outChar = "pos", modelTag = "glm|svm", type = "Pct")
suggest_gain(sSummary, outChar = "pos", modelTag = "glm|svm", type = "Gain")
suggest_gain(sSummary, outChar = "pos", modelTag = "glm|svm", type = "Gain") + xlim(0, 0.5)

# vignette("modeval") #check a vignette for further details
}
}
