% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DNEDensities.R
\name{DNEDensities}
\alias{DNEDensities}
\title{Plot advanced results of a DNE surface analysis}
\usage{
DNEDensities(
  DNE_File,
  main = "",
  type = "DNE",
  legendPos = "topright",
  convexCol = "hotpink",
  concaveCol = "deepskyblue"
)
}
\arguments{
\item{DNE_File}{An object that stores the output of the DNE
function}

\item{main}{User's title for plot. Default is blank}

\item{type}{string determining which density plots to make. Default}

\item{legendPos}{string to determine location of the legend. Default='topright'
see details.
is to plot DNE face densities. Alternatively can plot face areas with 'area'}

\item{convexCol}{Color for the convex density polygon, Default='hotpink'}

\item{concaveCol}{Color for the concave density polygon, Default='deepskyblue'}
}
\description{
Plot advanced results of a DNE surface analysis
}
\details{
This function creates a set of overlapping density plots of two potential types.
The user can plot overlapping density plots that sort the surface into concave and convex
portions for plotting. The function will default to plotting DNE density values, however
density of face surface areas sorted into concave and convex portions of the surface
can be plotted by calling \code{type='area'}. Colors can be customized by altering the
\code{convexCol} and \code{concaveCol} arguments.
}
\examples{
DNE_output <- DNE(Tooth)
DNEDensities(DNE_output)
}
